/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.partyanimals.manager;

import com.destroystokyo.paper.entity.ai.Goal;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.Event;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Transformation;
import org.maboroshi.partyanimals.PartyAnimals;
import org.maboroshi.partyanimals.api.event.pinata.PinataSpawnEvent;
import org.maboroshi.partyanimals.behavior.PinataFleeGoal;
import org.maboroshi.partyanimals.behavior.PinataFloatGoal;
import org.maboroshi.partyanimals.behavior.PinataRoamGoal;
import org.maboroshi.partyanimals.config.ConfigManager;
import org.maboroshi.partyanimals.config.settings.PinataConfig;
import org.maboroshi.partyanimals.handler.EffectHandler;
import org.maboroshi.partyanimals.manager.BossBarManager;
import org.maboroshi.partyanimals.util.Logger;
import org.maboroshi.partyanimals.util.MessageUtils;

public class PinataManager {
    private final PartyAnimals plugin;
    private final Logger log;
    private final ConfigManager config;
    private final BossBarManager bossBarManager;
    private final EffectHandler effectHandler;
    private final MessageUtils messageUtils;
    private final NamespacedKey is_pinata;
    private final NamespacedKey health;
    private final NamespacedKey max_health;
    private final NamespacedKey hit_cooldown;
    private final NamespacedKey spawn_time;
    private final NamespacedKey pinata_template;
    private final Map<UUID, LivingEntity> activePinatas = new HashMap<UUID, LivingEntity>();
    private final Map<UUID, ScheduledTask> timeoutTasks = new HashMap<UUID, ScheduledTask>();
    private final Map<ScheduledTask, UUID> activeCountdowns = new ConcurrentHashMap<ScheduledTask, UUID>();

    public PinataManager(PartyAnimals plugin) {
        this.plugin = plugin;
        this.log = plugin.getPluginLogger();
        this.config = plugin.getConfiguration();
        this.bossBarManager = plugin.getBossBarManager();
        this.effectHandler = plugin.getEffectHandler();
        this.messageUtils = plugin.getMessageUtils();
        this.is_pinata = new NamespacedKey((Plugin)plugin, "is_pinata");
        this.health = new NamespacedKey((Plugin)plugin, "health");
        this.max_health = new NamespacedKey((Plugin)plugin, "max_health");
        this.hit_cooldown = new NamespacedKey((Plugin)plugin, "hit_cooldown");
        this.spawn_time = new NamespacedKey((Plugin)plugin, "spawn_time");
        this.pinata_template = new NamespacedKey((Plugin)plugin, "pinata_template");
    }

    public PinataConfig.PinataConfiguration getPinataConfig(LivingEntity entity) {
        if (entity == null) {
            return this.config.getPinataConfig("default");
        }
        String id = (String)entity.getPersistentDataContainer().get(this.pinata_template, PersistentDataType.STRING);
        PinataConfig.PinataConfiguration pc = this.config.getPinataConfig(id != null ? id : "default");
        return pc != null ? pc : this.config.getPinataConfig("default");
    }

    public void startCountdown(Location location, String templateId) {
        PinataConfig.PinataConfiguration pinataConfig = this.config.getPinataConfig(templateId);
        if (pinataConfig == null) {
            this.log.warn("Tried to start countdown for invalid pinata template: " + templateId);
            return;
        }
        double countdownSeconds = pinataConfig.timer.countdown.duration;
        if (countdownSeconds <= 0.0) {
            this.spawnPinata(location, templateId);
            return;
        }
        this.effectHandler.playEffects(pinataConfig.timer.countdown.start, location, true);
        int totalSeconds = (int)countdownSeconds;
        long durationMillis = (long)(countdownSeconds * 1000.0);
        long endTime = System.currentTimeMillis() + durationMillis;
        UUID countdownId = this.bossBarManager.createCountdownBossBar(location, pinataConfig, totalSeconds);
        int[] lastSeconds = new int[]{totalSeconds};
        int[] taskDurationTicks = new int[]{0};
        ScheduledTask scheduledTask = Bukkit.getRegionScheduler().runAtFixedRate((Plugin)this.plugin, location, task -> {
            long now = System.currentTimeMillis();
            long remainingMilis = endTime - now;
            int displaySeconds = (int)Math.ceil((double)remainingMilis / 1000.0);
            if (remainingMilis <= 0L) {
                this.bossBarManager.removeCountdownBossBar(countdownId);
                this.effectHandler.playEffects(pinataConfig.timer.countdown.end, location, true);
                this.spawnPinata(location, templateId);
                this.activeCountdowns.remove(task);
                task.cancel();
                return;
            }
            taskDurationTicks[0] = taskDurationTicks[0] + 1;
            this.bossBarManager.updateCountdownBar(countdownId, displaySeconds, totalSeconds, pinataConfig, taskDurationTicks[0]);
            if (displaySeconds != lastSeconds[0]) {
                this.effectHandler.playEffects(pinataConfig.timer.countdown.mid, location, true);
                lastSeconds[0] = displaySeconds;
            }
        }, 1L, 1L);
        this.activeCountdowns.put(scheduledTask, countdownId);
    }

    public void spawnPinata(Location location, String templateId) {
        PinataConfig.PinataConfiguration pinataConfig = this.config.getPinataConfig(templateId);
        if (pinataConfig == null) {
            this.log.error("Cannot spawn pinata! Template '" + templateId + "' not found.");
            return;
        }
        Location spawnLocation = location.clone();
        spawnLocation.setPitch(0.0f);
        List<String> types = pinataConfig.appearance.entityTypes;
        String randomType = types.get(ThreadLocalRandom.current().nextInt(types.size()));
        EntityType pinataType = EntityType.valueOf((String)randomType.toUpperCase());
        double minScale = pinataConfig.appearance.scale.min;
        double maxScale = pinataConfig.appearance.scale.max;
        double finalScale = minScale >= maxScale ? minScale : ThreadLocalRandom.current().nextDouble(minScale, maxScale);
        int baseHealth = pinataConfig.health.baseHealth;
        int calculatedHealth = pinataConfig.health.perPlayer ? baseHealth * Math.max(1, this.plugin.getServer().getOnlinePlayers().size()) : baseHealth;
        int finalHealth = Math.min(calculatedHealth, pinataConfig.health.maxHealth);
        Entity pinata = location.getWorld().spawn(spawnLocation, pinataType.getEntityClass(), entity -> {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                this.initializePinataEntity(livingEntity, pinataConfig, templateId, finalHealth, finalScale);
                PinataSpawnEvent event = new PinataSpawnEvent(livingEntity, spawnLocation);
                this.plugin.getServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    this.log.debug("Pinata spawn event was cancelled by an API event; removing entity.");
                    livingEntity.remove();
                    return;
                }
                if (pinataConfig.appearance.nameTag.enabled) {
                    this.spawnNameTag(livingEntity);
                }
                this.activatePinata(livingEntity);
                this.log.debug("Playing pinata spawn effect at location: " + String.valueOf(location) + " for entity: " + String.valueOf(livingEntity.getType()) + " (Template: " + templateId + ")");
                this.effectHandler.playEffects(pinataConfig.events.spawn.effects, location, false);
            }
        });
        if (this.plugin.getActionHandler() != null) {
            this.plugin.getActionHandler().process(null, pinataConfig.events.spawn.rewards.values(), cmd -> {
                if (pinata instanceof LivingEntity) {
                    LivingEntity livingPinata = (LivingEntity)pinata;
                    return this.plugin.getMessageUtils().parsePinataPlaceholders(livingPinata, (String)cmd);
                }
                return cmd;
            });
        }
        String spawnMessage = this.config.getMessageConfig().pinata.events.spawnedNaturally;
        this.messageUtils.send((Audience)this.plugin.getServer(), spawnMessage, this.messageUtils.tagParsed("pinata", pinataConfig.appearance.name), this.messageUtils.tagParsed("location", location.getBlockX() + ", " + location.getBlockY() + ", " + location.getBlockZ()));
    }

    private void initializePinataEntity(LivingEntity livingEntity, PinataConfig.PinataConfiguration pinataConfig, String templateId, int health, double scale) {
        String colorName;
        NamedTextColor glowColor;
        livingEntity.getPersistentDataContainer().set(this.pinata_template, PersistentDataType.STRING, (Object)templateId);
        livingEntity.getPersistentDataContainer().set(this.is_pinata, PersistentDataType.BOOLEAN, (Object)true);
        livingEntity.getPersistentDataContainer().set(this.health, PersistentDataType.INTEGER, (Object)health);
        livingEntity.getPersistentDataContainer().set(this.max_health, PersistentDataType.INTEGER, (Object)health);
        livingEntity.getPersistentDataContainer().set(this.spawn_time, PersistentDataType.LONG, (Object)System.currentTimeMillis());
        livingEntity.getAttribute(Attribute.SCALE).setBaseValue(scale);
        livingEntity.setMaximumNoDamageTicks(0);
        livingEntity.setSilent(true);
        livingEntity.setInvulnerable(false);
        livingEntity.setRemoveWhenFarAway(false);
        livingEntity.setMaximumAir(100000);
        livingEntity.setRemainingAir(100000);
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            mob.setTarget(null);
        }
        livingEntity.setGlowing(pinataConfig.appearance.glowing);
        if (pinataConfig.appearance.glowing && (glowColor = (NamedTextColor)NamedTextColor.NAMES.value((Object)(colorName = pinataConfig.appearance.glowColor).toLowerCase())) != null) {
            String teamName;
            Scoreboard mainBoard = Bukkit.getScoreboardManager().getMainScoreboard();
            Team team = mainBoard.getTeam(teamName = "PA_" + glowColor.toString().toUpperCase());
            if (team == null) {
                team = mainBoard.registerNewTeam(teamName);
            }
            team.color(glowColor);
            team.addEntry(livingEntity.getUniqueId().toString());
        }
    }

    public void activatePinata(LivingEntity pinata) {
        if (pinata == null || pinata.isDead()) {
            return;
        }
        PinataConfig.PinataConfiguration pinataConfig = this.getPinataConfig(pinata);
        this.activePinatas.put(pinata.getUniqueId(), pinata);
        this.applyPinataGoal(pinata);
        this.startUpdateTask(pinata);
        this.startTimeoutTask(pinata);
        if (pinataConfig.appearance.nameTag.enabled) {
            boolean tagFound = false;
            if (pinata.getPassengers() != null) {
                for (Entity passenger : pinata.getPassengers()) {
                    if (!(passenger instanceof TextDisplay)) continue;
                    TextDisplay textDisplay = (TextDisplay)passenger;
                    this.startNameTagTask(pinata, textDisplay);
                    tagFound = true;
                    break;
                }
            }
            if (!tagFound) {
                this.spawnNameTag(pinata);
            }
        }
    }

    private void startUpdateTask(LivingEntity livingEntity) {
        PinataConfig.PinataConfiguration pinataConfig = this.getPinataConfig(livingEntity);
        int currentHealth = (Integer)livingEntity.getPersistentDataContainer().getOrDefault(this.health, PersistentDataType.INTEGER, (Object)pinataConfig.health.baseHealth);
        int maxHealthVal = (Integer)livingEntity.getPersistentDataContainer().getOrDefault(this.max_health, PersistentDataType.INTEGER, (Object)currentHealth);
        int timeout = pinataConfig.timer.timeout.duration;
        if (!this.bossBarManager.hasPinataBossBar(livingEntity.getUniqueId())) {
            this.bossBarManager.createPinataBossBar(livingEntity, currentHealth, maxHealthVal, timeout, pinataConfig);
        }
        livingEntity.getScheduler().runAtFixedRate((Plugin)this.plugin, task -> {
            if (!livingEntity.isValid()) {
                if (livingEntity.isDead()) {
                    this.removeActiveBossBar(livingEntity);
                }
                task.cancel();
                return;
            }
            if (!this.bossBarManager.hasPinataBossBar(livingEntity.getUniqueId())) {
                task.cancel();
                return;
            }
            int currHealth = (Integer)livingEntity.getPersistentDataContainer().getOrDefault(this.health, PersistentDataType.INTEGER, (Object)0);
            int maxHealth = (Integer)livingEntity.getPersistentDataContainer().getOrDefault(this.max_health, PersistentDataType.INTEGER, (Object)0);
            this.bossBarManager.updatePinataBossBar(livingEntity, currHealth, maxHealth, this.spawn_time, pinataConfig);
        }, () -> {}, 20L, 20L);
    }

    private void startTimeoutTask(LivingEntity pinata) {
        long elapsedMillis;
        long remainingMillis;
        long remainingTicks;
        ScheduledTask existing = this.timeoutTasks.remove(pinata.getUniqueId());
        if (existing != null) {
            existing.cancel();
        }
        PinataConfig.PinataConfiguration pinataConfig = this.getPinataConfig(pinata);
        if (!pinataConfig.timer.timeout.enabled) {
            return;
        }
        long spawnTime = (Long)pinata.getPersistentDataContainer().getOrDefault(this.spawn_time, PersistentDataType.LONG, (Object)0L);
        int timeoutSeconds = pinataConfig.timer.timeout.duration;
        if (spawnTime <= 0L) {
            spawnTime = System.currentTimeMillis();
        }
        if ((remainingTicks = (remainingMillis = (long)timeoutSeconds * 1000L - (elapsedMillis = System.currentTimeMillis() - spawnTime)) / 50L) <= 0L) {
            this.log.debug("Restoring pinata but timeout passed. Removing.");
            this.safelyRemovePinata(pinata);
            return;
        }
        ScheduledTask task = pinata.getScheduler().runDelayed((Plugin)this.plugin, t -> {
            if (pinata.isValid() && this.isPinata(pinata)) {
                this.safelyRemovePinata(pinata);
                String timeoutMsg = this.config.getMessageConfig().pinata.events.timeout;
                this.messageUtils.send((Audience)this.plugin.getServer(), timeoutMsg, new TagResolver[0]);
            }
            this.timeoutTasks.remove(pinata.getUniqueId());
        }, () -> {}, remainingTicks);
        this.timeoutTasks.put(pinata.getUniqueId(), task);
    }

    private void startNameTagTask(LivingEntity livingEntity, TextDisplay nameTag) {
        PinataConfig.PinataConfiguration pinataConfig = this.getPinataConfig(livingEntity);
        int interval = pinataConfig.appearance.nameTag.updateTextInterval;
        if (interval <= 0) {
            return;
        }
        long intervalTicks = interval;
        livingEntity.getScheduler().runAtFixedRate((Plugin)this.plugin, task -> {
            if (!nameTag.isValid() || !livingEntity.isValid()) {
                task.cancel();
                if (nameTag.isValid()) {
                    nameTag.remove();
                }
                return;
            }
            int currentHealth = (Integer)livingEntity.getPersistentDataContainer().getOrDefault(this.health, PersistentDataType.INTEGER, (Object)0);
            int maxHealthVal = (Integer)livingEntity.getPersistentDataContainer().getOrDefault(this.max_health, PersistentDataType.INTEGER, (Object)1);
            String timeStr = "\u221e";
            if (pinataConfig.timer.timeout.enabled && pinataConfig.timer.timeout.duration > 0) {
                long spawnTime = (Long)livingEntity.getPersistentDataContainer().getOrDefault(this.spawn_time, PersistentDataType.LONG, (Object)System.currentTimeMillis());
                int totalTimeout = pinataConfig.timer.timeout.duration;
                int remaining = Math.max(0, totalTimeout - (int)((System.currentTimeMillis() - spawnTime) / 1000L));
                timeStr = String.format("%02d:%02d", remaining / 60, remaining % 60);
            }
            List<String> lines = pinataConfig.appearance.nameTag.text;
            ArrayList<Component> components = new ArrayList<Component>();
            if (lines != null) {
                for (String line : lines) {
                    components.add(this.messageUtils.parse(null, line, this.messageUtils.tagParsed("pinata", pinataConfig.appearance.name), this.messageUtils.tag("health", currentHealth), this.messageUtils.tag("max-health", maxHealthVal), this.messageUtils.tag("timer", timeStr)));
                }
            }
            nameTag.text(Component.join((JoinConfiguration)JoinConfiguration.newlines(), components));
        }, () -> {}, intervalTicks, intervalTicks);
    }

    public void applyPinataGoal(LivingEntity pinata) {
        AttributeInstance knockbackAttribute;
        PinataConfig.PinataConfiguration pinataConfig = this.getPinataConfig(pinata);
        if (!pinataConfig.behavior.enabled) {
            pinata.setAI(false);
            return;
        }
        pinata.setAI(true);
        if (pinata instanceof Mob) {
            String activeMovementType;
            Mob mob = (Mob)pinata;
            Bukkit.getMobGoals().removeAllGoals(mob);
            Bukkit.getMobGoals().addGoal(mob, 0, (Goal)new PinataFloatGoal((Plugin)this.plugin, mob));
            String rawType = pinataConfig.behavior.movement.type;
            String string = activeMovementType = rawType != null ? rawType.toUpperCase() : "BOTH";
            if (!List.of("FLEE", "ROAM", "NONE", "BOTH").contains(activeMovementType)) {
                this.plugin.getPluginLogger().warn("Unknown movement type '" + activeMovementType + "' for pinata " + String.valueOf(mob.getUniqueId()) + ". Defaulting to BOTH.");
                activeMovementType = "BOTH";
            }
            switch (activeMovementType) {
                case "FLEE": {
                    Bukkit.getMobGoals().addGoal(mob, 2, (Goal)new PinataFleeGoal(this.plugin, mob));
                    break;
                }
                case "ROAM": {
                    Bukkit.getMobGoals().addGoal(mob, 2, (Goal)new PinataRoamGoal(this.plugin, mob));
                    break;
                }
                case "NONE": {
                    break;
                }
                case "BOTH": {
                    Bukkit.getMobGoals().addGoal(mob, 2, (Goal)new PinataFleeGoal(this.plugin, mob));
                    Bukkit.getMobGoals().addGoal(mob, 3, (Goal)new PinataRoamGoal(this.plugin, mob));
                }
            }
        }
        if ((knockbackAttribute = pinata.getAttribute(Attribute.KNOCKBACK_RESISTANCE)) != null) {
            knockbackAttribute.setBaseValue(pinataConfig.behavior.knockbackResistance);
        }
    }

    public void safelyRemovePinata(LivingEntity pinata) {
        if (pinata.getPassengers() != null) {
            for (Entity passenger : new ArrayList(pinata.getPassengers())) {
                passenger.remove();
            }
        }
        this.removeActiveBossBar(pinata);
        if (pinata.isValid()) {
            pinata.remove();
        }
    }

    public void removeActiveBossBar(LivingEntity pinata) {
        this.bossBarManager.removePinataBossBar(pinata.getUniqueId());
        this.activePinatas.remove(pinata.getUniqueId());
        ScheduledTask task = this.timeoutTasks.remove(pinata.getUniqueId());
        if (task != null) {
            task.cancel();
        }
    }

    private void spawnNameTag(LivingEntity pinata) {
        PinataConfig.PinataConfiguration pinataConfig = this.getPinataConfig(pinata);
        Location location = pinata.getLocation();
        TextDisplay nameTag = (TextDisplay)location.getWorld().spawnEntity(location, EntityType.TEXT_DISPLAY);
        nameTag.setPersistent(false);
        int currentHealth = (Integer)pinata.getPersistentDataContainer().getOrDefault(this.health, PersistentDataType.INTEGER, (Object)pinataConfig.health.baseHealth);
        int maxHealthVal = (Integer)pinata.getPersistentDataContainer().getOrDefault(this.max_health, PersistentDataType.INTEGER, (Object)currentHealth);
        int totalSeconds = pinataConfig.timer.timeout.duration;
        String initialTimeStr = "\u221e";
        if (pinataConfig.timer.timeout.enabled && totalSeconds > 0) {
            initialTimeStr = String.format("%02d:%02d", totalSeconds / 60, totalSeconds % 60);
        }
        List<String> lines = pinataConfig.appearance.nameTag.text;
        ArrayList<Component> components = new ArrayList<Component>();
        if (lines != null) {
            for (String line : lines) {
                components.add(this.messageUtils.parse(null, line, this.messageUtils.tagParsed("pinata", pinataConfig.appearance.name), this.messageUtils.tag("health", currentHealth), this.messageUtils.tag("max-health", maxHealthVal), this.messageUtils.tag("timer", initialTimeStr)));
            }
        }
        nameTag.text(Component.join((JoinConfiguration)JoinConfiguration.newlines(), components));
        nameTag.setAlignment(pinataConfig.appearance.nameTag.textAlignment);
        nameTag.setDefaultBackground(false);
        if (pinataConfig.appearance.nameTag.background.enabled) {
            nameTag.setBackgroundColor(Color.fromARGB((int)pinataConfig.appearance.nameTag.background.alpha, (int)pinataConfig.appearance.nameTag.background.red, (int)pinataConfig.appearance.nameTag.background.green, (int)pinataConfig.appearance.nameTag.background.blue));
        } else {
            nameTag.setBackgroundColor(Color.fromARGB((int)0, (int)0, (int)0, (int)0));
        }
        nameTag.setShadowed(pinataConfig.appearance.nameTag.shadow.enabled);
        nameTag.setShadowRadius(pinataConfig.appearance.nameTag.shadow.radius);
        nameTag.setShadowStrength(pinataConfig.appearance.nameTag.shadow.strength);
        nameTag.setBillboard(pinataConfig.appearance.nameTag.billboard);
        nameTag.setSeeThrough(pinataConfig.appearance.nameTag.seeThrough);
        Transformation nameTransform = nameTag.getTransformation();
        float scaleX = (float)pinataConfig.appearance.nameTag.transformation.scale.x;
        float scaleY = (float)pinataConfig.appearance.nameTag.transformation.scale.y;
        float scaleZ = (float)pinataConfig.appearance.nameTag.transformation.scale.z;
        float transX = (float)pinataConfig.appearance.nameTag.transformation.translation.x;
        float transY = (float)pinataConfig.appearance.nameTag.transformation.translation.y;
        float transZ = (float)pinataConfig.appearance.nameTag.transformation.translation.z;
        nameTransform.getTranslation().set(transX, transY, transZ);
        nameTransform.getScale().set(scaleX, scaleY, scaleZ);
        nameTag.setTransformation(nameTransform);
        pinata.addPassenger((Entity)nameTag);
    }

    public void cleanup() {
        this.cleanup(true);
    }

    public void cleanup(boolean killEntities) {
        this.log.debug("Running PinataManager cleanup (Kill entities: " + killEntities + ")...");
        this.bossBarManager.removeAll();
        for (LivingEntity entity : List.copyOf(this.activePinatas.values())) {
            if (!killEntities) continue;
            this.safelyRemovePinata(entity);
        }
        this.activePinatas.clear();
        this.timeoutTasks.values().forEach(ScheduledTask::cancel);
        this.timeoutTasks.clear();
        this.activeCountdowns.keySet().forEach(ScheduledTask::cancel);
        this.activeCountdowns.clear();
    }

    public boolean isPinata(LivingEntity pinata) {
        return pinata.getPersistentDataContainer().has(this.is_pinata, PersistentDataType.BOOLEAN);
    }

    public int getActivePinataCount() {
        return this.activePinatas.size();
    }

    public boolean isPinataAlive() {
        return !this.activePinatas.isEmpty();
    }

    public LivingEntity getNearestPinata(Location location) {
        if (this.activePinatas.isEmpty() || location == null) {
            return null;
        }
        LivingEntity nearest = null;
        double closestDistSq = Double.MAX_VALUE;
        for (LivingEntity pinata : this.activePinatas.values()) {
            double distSq;
            if (!pinata.isValid() || pinata.getWorld() != location.getWorld() || !((distSq = pinata.getLocation().distanceSquared(location)) < closestDistSq)) continue;
            closestDistSq = distSq;
            nearest = pinata;
        }
        return nearest;
    }

    public int getPinataHealth(LivingEntity pinata) {
        if (pinata == null || !pinata.isValid()) {
            return 0;
        }
        return (Integer)pinata.getPersistentDataContainer().getOrDefault(this.health, PersistentDataType.INTEGER, (Object)0);
    }

    public int getPinataMaxHealth(LivingEntity pinata) {
        if (pinata == null || !pinata.isValid()) {
            return 0;
        }
        return (Integer)pinata.getPersistentDataContainer().getOrDefault(this.max_health, PersistentDataType.INTEGER, (Object)0);
    }

    public NamespacedKey getHealthKey() {
        return this.health;
    }

    public NamespacedKey getMaxHealthKey() {
        return this.max_health;
    }

    public NamespacedKey getCooldownKey() {
        return this.hit_cooldown;
    }

    public NamespacedKey getSpawnTimeKey() {
        return this.spawn_time;
    }

    public NamespacedKey getTemplateKey() {
        return this.pinata_template;
    }
}

