/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.partyanimals.manager;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.maboroshi.partyanimals.PartyAnimals;
import org.maboroshi.partyanimals.config.settings.PinataConfig;
import org.maboroshi.partyanimals.util.MessageUtils;

public class BossBarManager {
    private final MessageUtils messageUtils;
    private final Map<UUID, BossBar> pinataBossBars = new ConcurrentHashMap<UUID, BossBar>();
    private final Map<UUID, BossBar> countdownBossBars = new ConcurrentHashMap<UUID, BossBar>();
    private final Map<UUID, Location> countdownLocations = new ConcurrentHashMap<UUID, Location>();
    private final Map<UUID, Boolean> countdownGlobalSettings = new ConcurrentHashMap<UUID, Boolean>();

    public BossBarManager(PartyAnimals plugin) {
        this.messageUtils = plugin.getMessageUtils();
    }

    public UUID createCountdownBossBar(Location location, PinataConfig.PinataConfiguration pinataConfig, int totalSeconds) {
        UUID uuid = UUID.randomUUID();
        PinataConfig.BossBarSettings barSettings = pinataConfig.timer.countdown.bar;
        boolean isRainbow = barSettings.color.equalsIgnoreCase("RAINBOW");
        BossBar bossBar = BossBar.bossBar((Component)this.messageUtils.parse(null, barSettings.text, this.messageUtils.tag("countdown", totalSeconds)), (float)1.0f, (BossBar.Color)(isRainbow ? BossBar.Color.PINK : BossBar.Color.valueOf((String)barSettings.color)), (BossBar.Overlay)barSettings.overlay);
        if (barSettings.enabled) {
            this.countdownBossBars.put(uuid, bossBar);
            this.countdownLocations.put(uuid, location);
            this.countdownGlobalSettings.put(uuid, barSettings.global);
            this.updateViewerList(bossBar, barSettings.global, location.getWorld().getName());
        }
        return uuid;
    }

    public void updateCountdownBar(UUID uuid, int remainingSeconds, int totalSeconds, PinataConfig.PinataConfiguration pinataConfig, int tickCounter) {
        Location location;
        BossBar bossBar = this.countdownBossBars.get(uuid);
        if (bossBar == null) {
            return;
        }
        PinataConfig.BossBarSettings countdownBarSettings = pinataConfig.timer.countdown.bar;
        float progress = Math.max(0.0f, Math.min(1.0f, (float)remainingSeconds / (float)totalSeconds));
        bossBar.progress(progress);
        bossBar.name(this.messageUtils.parse(null, countdownBarSettings.text, this.messageUtils.tag("countdown", remainingSeconds)));
        if (countdownBarSettings.color.equalsIgnoreCase("rainbow") && tickCounter % 5 == 0) {
            int next = (bossBar.color().ordinal() + 1) % BossBar.Color.values().length;
            bossBar.color(BossBar.Color.values()[next]);
        }
        if ((location = this.countdownLocations.get(uuid)) != null) {
            this.updateViewerList(bossBar, this.countdownGlobalSettings.get(uuid), location.getWorld().getName());
        }
    }

    public void removeCountdownBossBar(UUID uuid) {
        BossBar bar = this.countdownBossBars.remove(uuid);
        this.countdownLocations.remove(uuid);
        this.countdownGlobalSettings.remove(uuid);
        if (bar != null) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                p.hideBossBar(bar);
            }
        }
    }

    public void createPinataBossBar(LivingEntity pinata, int health, int maxHealth, int timeout, PinataConfig.PinataConfiguration pinataConfig) {
        String rawMsg = pinataConfig.health.bar.text;
        String timeStr = this.formatTime(timeout, pinataConfig);
        Component barName = this.messageUtils.parse(null, rawMsg, this.messageUtils.tagParsed("pinata", pinataConfig.appearance.name), this.messageUtils.tag("health", health), this.messageUtils.tag("max-health", maxHealth), this.messageUtils.tag("timer", timeStr));
        BossBar bossBar = BossBar.bossBar((Component)barName, (float)1.0f, (BossBar.Color)BossBar.Color.valueOf((String)pinataConfig.health.bar.color), (BossBar.Overlay)pinataConfig.health.bar.overlay);
        this.pinataBossBars.put(pinata.getUniqueId(), bossBar);
        this.updateViewerList(bossBar, pinataConfig.health.bar.global, pinata.getWorld().getName());
    }

    public void updatePinataBossBar(LivingEntity pinata, int currentHealth, int maxHealth, NamespacedKey spawnTimeKey, PinataConfig.PinataConfiguration pinataConfig) {
        BossBar bossBar = this.pinataBossBars.get(pinata.getUniqueId());
        if (bossBar == null || !pinataConfig.health.bar.enabled) {
            return;
        }
        float progress = Math.max(0.0f, Math.min(1.0f, (float)currentHealth / (float)maxHealth));
        bossBar.progress(progress);
        String timeStr = "\u221e";
        if (pinataConfig.timer.timeout.enabled) {
            long spawnTime = (Long)pinata.getPersistentDataContainer().getOrDefault(spawnTimeKey, PersistentDataType.LONG, (Object)System.currentTimeMillis());
            int totalTimeout = pinataConfig.timer.timeout.duration;
            int remaining = Math.max(0, totalTimeout - (int)((System.currentTimeMillis() - spawnTime) / 1000L));
            timeStr = this.formatTime(remaining, pinataConfig);
        }
        bossBar.name(this.messageUtils.parse(null, pinataConfig.health.bar.text, this.messageUtils.tagParsed("pinata", pinataConfig.appearance.name), this.messageUtils.tag("health", currentHealth), this.messageUtils.tag("max-health", maxHealth), this.messageUtils.tag("timer", timeStr)));
        this.updateViewerList(bossBar, pinataConfig.health.bar.global, pinata.getWorld().getName());
    }

    public boolean hasPinataBossBar(UUID uuid) {
        return this.pinataBossBars.containsKey(uuid);
    }

    public void removePinataBossBar(UUID uuid) {
        BossBar bar = this.pinataBossBars.remove(uuid);
        if (bar != null) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                p.hideBossBar(bar);
            }
        }
    }

    public Map<UUID, BossBar> getPinataBossBars() {
        return this.pinataBossBars;
    }

    public void removeAll() {
        this.pinataBossBars.values().forEach(bar -> Bukkit.getOnlinePlayers().forEach(p -> p.hideBossBar(bar)));
        this.pinataBossBars.clear();
        this.countdownBossBars.values().forEach(bar -> Bukkit.getOnlinePlayers().forEach(p -> p.hideBossBar(bar)));
        this.countdownBossBars.clear();
        this.countdownLocations.clear();
        this.countdownGlobalSettings.clear();
    }

    public void handleJoin(Player player) {
        this.pinataBossBars.forEach((uuid, bar) -> {
            LivingEntity livingEntity = (LivingEntity)Bukkit.getEntity((UUID)uuid);
            if (livingEntity != null && player.getWorld().equals((Object)livingEntity.getWorld())) {
                player.showBossBar(bar);
            }
        });
        this.countdownBossBars.forEach((uuid, bar) -> {
            Location location = this.countdownLocations.get(uuid);
            boolean global = this.countdownGlobalSettings.getOrDefault(uuid, true);
            if (global || location != null && location.getWorld().equals((Object)player.getWorld())) {
                player.showBossBar(bar);
            }
        });
    }

    private void updateViewerList(BossBar bar, boolean global, String worldName) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            boolean inSameWorld = p.getWorld().getName().equals(worldName);
            if (global || inSameWorld) {
                p.showBossBar(bar);
                continue;
            }
            p.hideBossBar(bar);
        }
    }

    private String formatTime(int seconds, PinataConfig.PinataConfiguration pinataConfig) {
        if (!pinataConfig.timer.timeout.enabled || seconds <= 0) {
            return "\u221e";
        }
        return String.format("%02d:%02d", seconds / 60, seconds % 60);
    }
}

