/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.partyanimals.listener;

import com.vexsoftware.votifier.model.Vote;
import com.vexsoftware.votifier.model.VotifierEvent;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.maboroshi.partyanimals.PartyAnimals;
import org.maboroshi.partyanimals.config.ConfigManager;
import org.maboroshi.partyanimals.config.objects.CommandAction;
import org.maboroshi.partyanimals.config.settings.MainConfig;
import org.maboroshi.partyanimals.handler.ActionHandler;
import org.maboroshi.partyanimals.handler.EffectHandler;
import org.maboroshi.partyanimals.manager.DatabaseManager;
import org.maboroshi.partyanimals.util.Logger;

public class VoteListener
implements Listener {
    private final PartyAnimals plugin;
    private final ConfigManager config;
    private final Logger log;
    private final EffectHandler effectHandler;
    private final ActionHandler actionHandler;
    private final DatabaseManager databaseManager;
    private static final Object LOCK = new Object();

    public VoteListener(PartyAnimals plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfiguration();
        this.log = plugin.getPluginLogger();
        this.effectHandler = plugin.getEffectHandler();
        this.actionHandler = plugin.getActionHandler();
        this.databaseManager = plugin.getDatabaseManager();
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        if (!this.config.getMainConfig().modules.vote.offline.enabled || !this.config.getMainConfig().modules.vote.offline.queueRewards) {
            return;
        }
        Player player = event.getPlayer();
        Bukkit.getAsyncScheduler().runNow((Plugin)this.plugin, task -> {
            UUID uuid = this.databaseManager.getPlayerUUID(player.getName());
            if (uuid == null) {
                return;
            }
            List<String> commands = this.databaseManager.retrieveRewards(uuid);
            if (!commands.isEmpty()) {
                player.getScheduler().run((Plugin)this.plugin, scheduledTask -> {
                    this.log.debug("Delivering " + commands.size() + " offline rewards to " + player.getName());
                    for (String cmd : commands) {
                        String finalCmd = cmd.replace("<player>", player.getName()).replace("<uuid>", player.getUniqueId().toString());
                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)finalCmd);
                    }
                }, null);
            }
        });
    }

    @EventHandler
    public void onVoteEvent(VotifierEvent event) {
        if (!this.config.getMainConfig().modules.vote.enabled) {
            return;
        }
        Vote vote = event.getVote();
        String serviceName = vote.getServiceName();
        String playerName = vote.getUsername();
        Bukkit.getAsyncScheduler().runNow((Plugin)this.plugin, task -> {
            UUID uuid = this.databaseManager.getPlayerUUID(playerName);
            if (uuid == null) {
                return;
            }
            Object object = LOCK;
            synchronized (object) {
                MainConfig.VoteLimitSettings limitSettings = this.config.getMainConfig().modules.vote.events.playerVote.dailyLimit;
                int limit = limitSettings.enabled ? limitSettings.amount : -1;
                boolean countExcess = limitSettings.countExcessVotes;
                DatabaseManager.VoteResult result = this.databaseManager.processVote(uuid, playerName, serviceName, 1, limit, countExcess);
                if (result != DatabaseManager.VoteResult.FAIL_IGNORED && !serviceName.equals("TestVote (Dry Run)")) {
                    int currentTotal;
                    MainConfig.CommunityGoalSettings goalConfig = this.config.getMainConfig().modules.vote.communityGoal;
                    if (goalConfig.enabled && goalConfig.votesRequired > 0 && (currentTotal = this.databaseManager.incrementCommunityGoalProgress()) % goalConfig.votesRequired == 0) {
                        Bukkit.getGlobalRegionScheduler().execute((Plugin)this.plugin, () -> this.actionHandler.process(null, goalConfig.rewards.values()));
                    }
                }
                if (result == DatabaseManager.VoteResult.SUCCESS_NO_REWARD) {
                    this.log.debug(playerName + " limit reached (Vote saved, Reward skipped).");
                    Bukkit.getGlobalRegionScheduler().execute((Plugin)this.plugin, () -> {
                        Player player = Bukkit.getPlayer((String)playerName);
                        if (player != null) {
                            this.actionHandler.process((OfflinePlayer)player, limitSettings.actions.values());
                        }
                    });
                } else if (result == DatabaseManager.VoteResult.SUCCESS_REWARD) {
                    Bukkit.getGlobalRegionScheduler().execute((Plugin)this.plugin, () -> {
                        Player player = Bukkit.getPlayer((String)playerName);
                        if (player != null) {
                            player.getScheduler().run((Plugin)this.plugin, st -> {
                                MainConfig.VoteEvent voteEvent = this.config.getMainConfig().modules.vote.events.playerVote;
                                if (!voteEvent.enabled) {
                                    return;
                                }
                                this.effectHandler.playEffects(voteEvent.effects, player.getLocation(), false);
                                this.actionHandler.process((OfflinePlayer)player, voteEvent.rewards.values());
                            }, null);
                        } else {
                            this.processOfflineRewards(uuid, playerName);
                        }
                    });
                }
            }
        });
    }

    private void processOfflineRewards(UUID uuid, String playerName) {
        MainConfig.OfflineVoteSettings offlineSettings = this.config.getMainConfig().modules.vote.offline;
        if (offlineSettings.enabled) {
            MainConfig.VoteEvent voteEvent = this.config.getMainConfig().modules.vote.events.playerVote;
            if (offlineSettings.queueRewards) {
                Bukkit.getAsyncScheduler().runNow((Plugin)this.plugin, at -> {
                    for (CommandAction action : voteEvent.rewards.values()) {
                        if (!this.shouldRun(action)) continue;
                        this.processActionForQueue(uuid, playerName, action);
                        if (!action.stopProcessing) continue;
                        break;
                    }
                });
            } else {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
                this.actionHandler.process(offlinePlayer, voteEvent.rewards.values());
            }
        }
    }

    private boolean shouldRun(CommandAction action) {
        if (action.chance >= 100.0) {
            return true;
        }
        return ThreadLocalRandom.current().nextDouble(100.0) <= action.chance;
    }

    private void processActionForQueue(UUID uuid, String playerName, CommandAction action) {
        if (action.commands.isEmpty()) {
            return;
        }
        if (action.pickOneRandom) {
            int index = ThreadLocalRandom.current().nextInt(action.commands.size());
            String cmd = action.commands.get(index);
            this.databaseManager.queueRewards(uuid, cmd);
        } else {
            for (String cmd : action.commands) {
                this.databaseManager.queueRewards(uuid, cmd);
            }
        }
    }
}

