/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.partyanimals.hook.migration;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.maboroshi.partyanimals.PartyAnimals;
import org.maboroshi.partyanimals.util.Logger;

public class PinataPartyMigration {
    private final PartyAnimals plugin;
    private final Logger log;

    public PinataPartyMigration(PartyAnimals plugin) {
        this.plugin = plugin;
        this.log = plugin.getPluginLogger();
    }

    public void migrate() {
        File legacyFile = new File(this.plugin.getDataFolder(), "data.yml");
        if (!legacyFile.exists()) {
            this.log.error("Migration failed: data.yml not found in plugin folder.");
            return;
        }
        YamlConfiguration oldData = YamlConfiguration.loadConfiguration((File)legacyFile);
        ConfigurationSection section = oldData.getConfigurationSection("player-votes");
        if (section == null || section.getKeys(false).isEmpty()) {
            this.log.warn("Migration: No 'player-votes' section found in data.yml.");
            return;
        }
        this.log.info("Migration: Starting import of " + section.getKeys(false).size() + " records...");
        String votesTable = this.plugin.getConfiguration().getMainConfig().database.tablePrefix + "votes";
        String sql = "INSERT INTO " + votesTable + " (uuid, username, service, amount, timestamp) VALUES (?, ?, ?, ?, ?);";
        try (Connection conn = this.plugin.getDatabaseManager().getConnection();){
            conn.setAutoCommit(false);
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                for (String uuidStr : section.getKeys(false)) {
                    int votes = section.getInt(uuidStr);
                    if (votes <= 0) continue;
                    stmt.setString(1, uuidStr);
                    stmt.setString(2, "Legacy-Player");
                    stmt.setString(3, "PinataParty-Migration");
                    stmt.setInt(4, votes);
                    stmt.setLong(5, 0L);
                    stmt.addBatch();
                }
                stmt.executeBatch();
                conn.commit();
                this.log.info("Migration: Successfully imported legacy data.");
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        catch (SQLException e) {
            this.log.error("Database error during migration: " + e.getMessage());
            return;
        }
        File backup = new File(this.plugin.getDataFolder(), "data.yml.converted");
        legacyFile.renameTo(backup);
    }
}

