/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.partyanimals.handler;

import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;
import org.maboroshi.partyanimals.PartyAnimals;
import org.maboroshi.partyanimals.config.settings.PinataConfig;
import org.maboroshi.partyanimals.handler.ActionHandler;
import org.maboroshi.partyanimals.handler.EffectHandler;

public class ReflexHandler {
    private final PartyAnimals plugin;
    private final EffectHandler effectHandler;
    private final ActionHandler actionHandler;

    public ReflexHandler(PartyAnimals plugin) {
        this.plugin = plugin;
        this.effectHandler = plugin.getEffectHandler();
        this.actionHandler = plugin.getActionHandler();
    }

    public void onDamage(LivingEntity pinata, Player attacker, PinataConfig.PinataConfiguration config) {
        if (!config.behavior.enabled) {
            return;
        }
        PinataConfig.ShockwaveReflex shockwave = config.behavior.reflexes.shockwave;
        if (shockwave.enabled && this.shouldTrigger(shockwave.chance)) {
            this.effectHandler.playEffects(shockwave.effects, pinata.getLocation(), false);
            pinata.getNearbyEntities(shockwave.radius, shockwave.radius, shockwave.radius).forEach(entity -> {
                Player player;
                if (entity instanceof Player && !(player = (Player)entity).equals((Object)pinata)) {
                    Vector direction = player.getLocation().toVector().subtract(pinata.getLocation().toVector());
                    if (direction.lengthSquared() < 0.01) {
                        direction = new Vector(0.0, shockwave.verticalBoost, 0.0);
                    } else {
                        direction.normalize().multiply(shockwave.strength).setY(shockwave.verticalBoost);
                    }
                    player.setVelocity(direction);
                }
            });
            if (!shockwave.commands.isEmpty()) {
                this.actionHandler.process((OfflinePlayer)attacker, shockwave.commands.values(), cmd -> this.plugin.getMessageUtils().parsePinataPlaceholders(pinata, (String)cmd));
            }
        }
        PinataConfig.MorphReflex morph = config.behavior.reflexes.morph;
        if (morph.enabled && this.shouldTrigger(morph.chance)) {
            this.effectHandler.playEffects(morph.effects, pinata.getLocation(), false);
            if (morph.type.equalsIgnoreCase("AGE")) {
                if (pinata instanceof Ageable) {
                    Ageable ageable = (Ageable)pinata;
                    ageable.setBaby();
                    pinata.getScheduler().runDelayed((Plugin)this.plugin, task -> {
                        if (pinata.isValid()) {
                            ageable.setAdult();
                        }
                    }, null, (long)morph.duration);
                }
            } else if (morph.type.equalsIgnoreCase("SCALE")) {
                AttributeInstance scaleAttribute = pinata.getAttribute(Attribute.SCALE);
                if (scaleAttribute != null) {
                    double originalScale = scaleAttribute.getBaseValue();
                    double min = Math.min(morph.scale.min, morph.scale.max);
                    double max = Math.max(morph.scale.min, morph.scale.max);
                    double newScale = ThreadLocalRandom.current().nextDouble(min, max);
                    scaleAttribute.setBaseValue(newScale);
                    pinata.getScheduler().runDelayed((Plugin)this.plugin, task -> {
                        if (pinata.isValid()) {
                            scaleAttribute.setBaseValue(originalScale);
                        }
                    }, null, (long)morph.duration);
                }
            } else {
                this.plugin.getPluginLogger().warn("Unknown morph type: " + morph.type);
            }
            if (!morph.commands.isEmpty()) {
                this.actionHandler.process((OfflinePlayer)attacker, morph.commands.values(), cmd -> this.plugin.getMessageUtils().parsePinataPlaceholders(pinata, (String)cmd));
            }
        }
        PinataConfig.BlinkReflex blink = config.behavior.reflexes.blink;
        if (blink.enabled && this.shouldTrigger(blink.chance)) {
            this.effectHandler.playEffects(blink.effects, pinata.getLocation(), false);
            Location location = pinata.getLocation();
            double x = location.getX() + (ThreadLocalRandom.current().nextDouble() - 0.5) * blink.distance * 2.0;
            double z = location.getZ() + (ThreadLocalRandom.current().nextDouble() - 0.5) * blink.distance * 2.0;
            Location target = this.findSafeY(pinata.getWorld(), x, z, location.getY(), 8);
            if (target != null) {
                target.setYaw(location.getYaw());
                target.setPitch(location.getPitch());
                pinata.teleport(target);
                if (!blink.commands.isEmpty()) {
                    this.actionHandler.process((OfflinePlayer)attacker, blink.commands.values(), cmd -> this.plugin.getMessageUtils().parsePinataPlaceholders(pinata, (String)cmd));
                }
            }
        }
        PinataConfig.LeapReflex leap = config.behavior.reflexes.leap;
        if (leap.enabled && this.shouldTrigger(leap.chance)) {
            double blinkDistance = config.behavior.reflexes.blink.distance;
            double thresholdSq = blinkDistance * blinkDistance;
            thresholdSq = Math.max(thresholdSq, 25.0);
            if (pinata.getLocation().distanceSquared(attacker.getLocation()) > thresholdSq) {
                return;
            }
            this.effectHandler.playEffects(leap.effects, pinata.getLocation(), false);
            pinata.setVelocity(new Vector(0.0, leap.strength, 0.0));
            if (!leap.commands.isEmpty()) {
                this.actionHandler.process((OfflinePlayer)attacker, leap.commands.values(), cmd -> this.plugin.getMessageUtils().parsePinataPlaceholders(pinata, (String)cmd));
            }
        }
        PinataConfig.SugarRushReflex sugarRush = config.behavior.reflexes.sugarRush;
        if (sugarRush.enabled && this.shouldTrigger(sugarRush.chance)) {
            this.effectHandler.playEffects(sugarRush.effects, pinata.getLocation(), false);
            pinata.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, sugarRush.duration, sugarRush.amplifier));
            if (!sugarRush.commands.isEmpty()) {
                this.actionHandler.process((OfflinePlayer)attacker, sugarRush.commands.values(), cmd -> this.plugin.getMessageUtils().parsePinataPlaceholders(pinata, (String)cmd));
            }
        }
        PinataConfig.DazzleReflex dazzle = config.behavior.reflexes.dazzle;
        if (dazzle.enabled && this.shouldTrigger(dazzle.chance)) {
            this.effectHandler.playEffects(dazzle.effects, attacker.getEyeLocation(), false);
            attacker.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, dazzle.duration, 0));
            attacker.addPotionEffect(new PotionEffect(PotionEffectType.NAUSEA, dazzle.duration, 0));
            if (!dazzle.commands.isEmpty()) {
                this.actionHandler.process((OfflinePlayer)attacker, dazzle.commands.values(), cmd -> this.plugin.getMessageUtils().parsePinataPlaceholders(pinata, (String)cmd));
            }
        }
    }

    public boolean shouldTrigger(double chance) {
        return ThreadLocalRandom.current().nextDouble(100.0) < chance;
    }

    private Location findSafeY(World world, double x, double z, double startY, int verticalRange) {
        Location target = new Location(world, x, startY, z);
        if (this.isSafeLocation(target)) {
            return target;
        }
        for (int i = 1; i <= verticalRange; ++i) {
            target.setY(startY + (double)i);
            if (this.isSafeLocation(target)) {
                return target;
            }
            target.setY(startY - (double)i);
            if (!this.isSafeLocation(target)) continue;
            return target;
        }
        return null;
    }

    private boolean isSafeLocation(Location location) {
        Block feet = location.getBlock();
        if (feet.getRelative(BlockFace.DOWN).isPassable()) {
            return false;
        }
        if (!feet.isPassable()) {
            return false;
        }
        return feet.getRelative(BlockFace.UP).isPassable();
    }
}

