/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.partyanimals.command.subcommands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.maboroshi.partyanimals.PartyAnimals;
import org.maboroshi.partyanimals.hook.VotifierHook;
import org.maboroshi.partyanimals.hook.migration.PinataPartyMigration;
import org.maboroshi.partyanimals.util.MessageUtils;

public class VoteCommand {
    private final PartyAnimals plugin;
    private final MessageUtils messageUtils;

    public VoteCommand(PartyAnimals plugin) {
        this.plugin = plugin;
        this.messageUtils = plugin.getMessageUtils();
    }

    public LiteralArgumentBuilder<CommandSourceStack> build() {
        LiteralArgumentBuilder voteNode = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"vote").requires(s -> s.getSender().hasPermission("partyanimals.vote"))).then(Commands.literal((String)"check").then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests(this::suggestPlayers).executes(this::handleCheck)))).then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(s -> s.getSender().hasPermission("partyanimals.vote.add"))).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests(this::suggestPlayers).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> this.handleModify((CommandContext<CommandSourceStack>)ctx, "add")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").requires(s -> s.getSender().hasPermission("partyanimals.vote.remove"))).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests(this::suggestPlayers).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> this.handleModify((CommandContext<CommandSourceStack>)ctx, "remove")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").requires(s -> s.getSender().hasPermission("partyanimals.vote.set"))).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests(this::suggestPlayers).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> this.handleModify((CommandContext<CommandSourceStack>)ctx, "set")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"migrate").requires(s -> s.getSender().hasPermission("partyanimals.vote.migrate"))).then(Commands.literal((String)"PinataParty").executes(ctx -> {
            CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
            this.messageUtils.send((Audience)sender, "<yellow>Starting PinataParty migration...", new TagResolver[0]);
            new PinataPartyMigration(this.plugin).migrate();
            this.messageUtils.send((Audience)sender, "<yellow>Migration process finished. Check console for results.", new TagResolver[0]);
            return 1;
        })));
        if (Bukkit.getPluginManager().isPluginEnabled("Votifier")) {
            voteNode.then(((LiteralArgumentBuilder)Commands.literal((String)"send").requires(s -> s.getSender().hasPermission("partyanimals.vote.send"))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests(this::suggestPlayers).executes(ctx -> this.simulateVote((CommandContext<CommandSourceStack>)ctx, "FakeService"))).then(Commands.argument((String)"service", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> this.simulateVote((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"service"))))));
        }
        return voteNode;
    }

    private CompletableFuture<Suggestions> suggestPlayers(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        Bukkit.getOnlinePlayers().forEach(player -> builder.suggest(player.getName()));
        return builder.buildFuture();
    }

    private int handleCheck(CommandContext<CommandSourceStack> ctx) {
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        String targetName = StringArgumentType.getString(ctx, (String)"player");
        Bukkit.getAsyncScheduler().runNow((Plugin)this.plugin, task -> {
            UUID uuid = this.plugin.getDatabaseManager().getPlayerUUID(targetName);
            int votes = this.plugin.getDatabaseManager().getVotes(uuid);
            this.messageUtils.send((Audience)sender, "<prefix> <white>" + targetName + "</white> has <aqua>" + votes + "</aqua> votes.", new TagResolver[0]);
        });
        return 1;
    }

    private int handleModify(CommandContext<CommandSourceStack> ctx, String action) {
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        String targetName = StringArgumentType.getString(ctx, (String)"player");
        int amount = IntegerArgumentType.getInteger(ctx, (String)"amount");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            UUID uuid = this.plugin.getDatabaseManager().getPlayerUUID(targetName);
            int currentVotes = this.plugin.getDatabaseManager().getVotes(uuid);
            int finalChange = 0;
            if (action.equals("add")) {
                finalChange = amount;
            } else if (action.equals("remove")) {
                finalChange = -amount;
            } else if (action.equals("set")) {
                finalChange = amount - currentVotes;
            }
            if (finalChange == 0) {
                this.messageUtils.send((Audience)sender, "<prefix> <yellow>No changes made. " + targetName + " already has " + currentVotes + " votes.", new TagResolver[0]);
                return;
            }
            this.plugin.getDatabaseManager().addVote(uuid, targetName, "Admin", finalChange);
            int newTotal = currentVotes + finalChange;
            this.messageUtils.send((Audience)sender, "<prefix> <green>Updated votes for <white>" + targetName + "</white>.", new TagResolver[0]);
            this.messageUtils.send((Audience)sender, "<prefix> <gray>Old: <yellow>" + currentVotes + "</yellow> -> New: <aqua>" + newTotal + "</aqua>", new TagResolver[0]);
        });
        return 1;
    }

    private int simulateVote(CommandContext<CommandSourceStack> ctx, String serviceName) {
        String targetName = StringArgumentType.getString(ctx, (String)"player");
        VotifierHook.sendVote(((CommandSourceStack)ctx.getSource()).getSender(), targetName, serviceName, this.messageUtils);
        return 1;
    }
}

