/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.partyanimals.command.subcommands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.maboroshi.partyanimals.PartyAnimals;
import org.maboroshi.partyanimals.config.ConfigManager;
import org.maboroshi.partyanimals.config.objects.SerializableLocation;
import org.maboroshi.partyanimals.config.settings.PinataConfig;
import org.maboroshi.partyanimals.util.MessageUtils;

public class PinataCommand {
    private final PartyAnimals plugin;
    private final ConfigManager config;
    private final MessageUtils messageUtils;

    public PinataCommand(PartyAnimals plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfiguration();
        this.messageUtils = plugin.getMessageUtils();
    }

    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"pinata").requires(s -> s.getSender().hasPermission("partyanimals.pinata"))).then(this.buildStart())).then(this.buildSpawn())).then(this.buildKillAll())).then(this.buildSpawnPoint());
    }

    private LiteralArgumentBuilder<CommandSourceStack> buildStart() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"start").requires(s -> s.getSender().hasPermission("partyanimals.pinata.start"))).executes(ctx -> this.handleStart((CommandSourceStack)ctx.getSource(), null, "default"))).then(((RequiredArgumentBuilder)Commands.argument((String)"pinata", (ArgumentType)StringArgumentType.word()).suggests(this::suggestPinataTemplates).executes(ctx -> this.handleStart((CommandSourceStack)ctx.getSource(), null, StringArgumentType.getString((CommandContext)ctx, (String)"pinata")))).then(Commands.argument((String)"location", (ArgumentType)StringArgumentType.word()).suggests(this::suggestCentralLocations).executes(ctx -> this.handleStart((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"location"), StringArgumentType.getString((CommandContext)ctx, (String)"pinata")))));
    }

    private LiteralArgumentBuilder<CommandSourceStack> buildSpawn() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"spawn").requires(s -> s.getSender().hasPermission("partyanimals.pinata.spawn"))).executes(ctx -> this.handleSpawn((CommandSourceStack)ctx.getSource(), null, "default"))).then(((RequiredArgumentBuilder)Commands.argument((String)"pinata", (ArgumentType)StringArgumentType.word()).suggests(this::suggestPinataTemplates).executes(ctx -> this.handleSpawn((CommandSourceStack)ctx.getSource(), null, StringArgumentType.getString((CommandContext)ctx, (String)"pinata")))).then(Commands.argument((String)"location", (ArgumentType)StringArgumentType.word()).suggests(this::suggestCentralLocations).executes(ctx -> this.handleSpawn((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"location"), StringArgumentType.getString((CommandContext)ctx, (String)"pinata")))));
    }

    private LiteralArgumentBuilder<CommandSourceStack> buildKillAll() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"killall").requires(s -> s.getSender().hasPermission("partyanimals.pinata.killall"))).executes(ctx -> {
            this.plugin.getPinataManager().cleanup();
            this.messageUtils.send((Audience)((CommandSourceStack)ctx.getSource()).getSender(), "<prefix> <green>Killed all active pinatas.", new TagResolver[0]);
            return 1;
        });
    }

    private LiteralArgumentBuilder<CommandSourceStack> buildSpawnPoint() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"spawnpoint").then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(s -> s.getSender().hasPermission("partyanimals.pinata.spawnpoint.add"))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(this::handleAddSpawnPoint)))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").requires(s -> s.getSender().hasPermission("partyanimals.pinata.spawnpoint.remove"))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests(this::suggestCentralLocations).executes(this::handleRemoveSpawnPoint)));
    }

    private int handleStart(CommandSourceStack source, String locationName, String templateId) {
        Location location = this.resolveLocation(source, locationName, templateId, "start");
        if (location == null) {
            return 1;
        }
        this.plugin.getPinataManager().startCountdown(location, templateId);
        String pinataName = this.config.getPinataConfig((String)templateId).appearance.name;
        this.messageUtils.send((Audience)source.getSender(), this.config.getMessageConfig().pinata.events.starting, this.messageUtils.tagParsed("pinata", pinataName), this.messageUtils.tagParsed("location", location.getBlockX() + ", " + location.getBlockY() + ", " + location.getBlockZ()));
        return 1;
    }

    private int handleSpawn(CommandSourceStack source, String locationName, String templateId) {
        Location location = this.resolveLocation(source, locationName, templateId, "spawn");
        if (location == null) {
            return 1;
        }
        this.plugin.getPinataManager().spawnPinata(location, templateId);
        String pinataName = this.config.getPinataConfig((String)templateId).appearance.name;
        this.messageUtils.send((Audience)source.getSender(), this.config.getMessageConfig().pinata.events.spawned, this.messageUtils.tagParsed("pinata", pinataName), this.messageUtils.tagParsed("location", location.getBlockX() + ", " + location.getBlockY() + ", " + location.getBlockZ()));
        return 1;
    }

    private int handleAddSpawnPoint(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        CommandSender commandSender = source.getSender();
        if (!(commandSender instanceof Player)) {
            this.messageUtils.send((Audience)source.getSender(), this.config.getMessageConfig().commands.playerOnly, new TagResolver[0]);
            return 1;
        }
        Player player = (Player)commandSender;
        String locationName = StringArgumentType.getString(ctx, (String)"name");
        SerializableLocation spawnLocation = new SerializableLocation(player.getLocation());
        this.config.getMainConfig().modules.pinata.spawnPoints.put(locationName, spawnLocation);
        this.config.saveConfig();
        this.messageUtils.send((Audience)player, this.config.getMessageConfig().pinata.admin.spawnPointAdded, this.messageUtils.tag("location", locationName));
        return 1;
    }

    private int handleRemoveSpawnPoint(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        String locationName = StringArgumentType.getString(ctx, (String)"name");
        SerializableLocation removed = this.config.getMainConfig().modules.pinata.spawnPoints.remove(locationName);
        if (removed != null) {
            this.config.saveConfig();
            this.messageUtils.send((Audience)source.getSender(), this.config.getMessageConfig().pinata.admin.spawnPointRemoved, this.messageUtils.tag("location", locationName));
        } else {
            this.messageUtils.send((Audience)source.getSender(), this.config.getMessageConfig().pinata.admin.spawnPointUnknown, this.messageUtils.tag("location", locationName));
        }
        return 1;
    }

    private Location resolveLocation(CommandSourceStack source, String locationName, String templateId, String commandContext) {
        if (locationName != null) {
            PinataConfig.PinataConfiguration pinataConfig = this.config.getPinataConfig(templateId);
            if (pinataConfig == null) {
                this.messageUtils.send((Audience)source.getSender(), this.config.getMessageConfig().pinata.admin.unknownTemplate, this.messageUtils.tagParsed("pinata", templateId));
                return null;
            }
            SerializableLocation spawnLocation = this.config.getMainConfig().modules.pinata.spawnPoints.get(locationName);
            if (spawnLocation == null) {
                this.messageUtils.send((Audience)source.getSender(), this.config.getMessageConfig().pinata.admin.spawnPointUnknown, this.messageUtils.tagParsed("pinata", templateId), this.messageUtils.tag("location", locationName));
                return null;
            }
            return spawnLocation.toBukkit();
        }
        CommandSender commandSender = source.getSender();
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            return player.getLocation();
        }
        this.sendUsage(source.getSender(), "/partyanimals pinata " + commandContext + " [template] [location]");
        return null;
    }

    private void sendUsage(CommandSender sender, String usage) {
        this.messageUtils.send((Audience)sender, this.config.getMessageConfig().commands.usageHelp, this.messageUtils.tag("usage-help", usage));
    }

    private CompletableFuture<Suggestions> suggestPinataTemplates(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        this.config.getPinataConfigs().keySet().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestCentralLocations(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        if (this.config.getMainConfig().modules.pinata.spawnPoints != null) {
            this.config.getMainConfig().modules.pinata.spawnPoints.keySet().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        }
        return builder.buildFuture();
    }
}

