/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.partyanimals.manager;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.maboroshi.partyanimals.PartyAnimals;
import org.maboroshi.partyanimals.config.settings.PinataConfig;
import org.maboroshi.partyanimals.util.MessageUtils;

public class BossBarManager {
    private final MessageUtils messageUtils;
    private final Map<UUID, BossBar> activeBossBars = new HashMap<UUID, BossBar>();

    public BossBarManager(PartyAnimals plugin) {
        this.messageUtils = plugin.getMessageUtils();
    }

    public void createBossBar(LivingEntity pinata, int health, int maxHealth, int timeout, PinataConfig.PinataConfiguration pinataConfig) {
        String rawMsg = pinataConfig.health.bar.text;
        String timeStr = this.formatTime(timeout, pinataConfig);
        Component barName = this.messageUtils.parse(null, rawMsg, this.messageUtils.tagParsed("pinata", pinataConfig.appearance.name), this.messageUtils.tag("health", health), this.messageUtils.tag("max-health", maxHealth), this.messageUtils.tag("timer", timeStr));
        BossBar bossBar = BossBar.bossBar((Component)barName, (float)1.0f, (BossBar.Color)pinataConfig.health.bar.color, (BossBar.Overlay)pinataConfig.health.bar.overlay);
        this.activeBossBars.put(pinata.getUniqueId(), bossBar);
        this.updateViewerList(pinata, bossBar, pinataConfig);
    }

    public void updateBossBar(LivingEntity pinata, int currentHealth, int maxHealth, NamespacedKey spawnTimeKey, PinataConfig.PinataConfiguration pinataConfig) {
        BossBar bossBar = this.activeBossBars.get(pinata.getUniqueId());
        if (bossBar == null || !pinataConfig.health.bar.enabled) {
            return;
        }
        float progress = Math.max(0.0f, Math.min(1.0f, (float)currentHealth / (float)maxHealth));
        bossBar.progress(progress);
        String timeStr = "\u221e";
        if (pinataConfig.timer.timeout.enabled) {
            long spawnTime = (Long)pinata.getPersistentDataContainer().getOrDefault(spawnTimeKey, PersistentDataType.LONG, (Object)System.currentTimeMillis());
            int totalTimeout = pinataConfig.timer.timeout.duration;
            int remaining = Math.max(0, totalTimeout - (int)((System.currentTimeMillis() - spawnTime) / 1000L));
            timeStr = this.formatTime(remaining, pinataConfig);
        }
        bossBar.name(this.messageUtils.parse(null, pinataConfig.health.bar.text, this.messageUtils.tagParsed("pinata", pinataConfig.appearance.name), this.messageUtils.tag("health", currentHealth), this.messageUtils.tag("max-health", maxHealth), this.messageUtils.tag("timer", timeStr)));
        this.updateViewerList(pinata, bossBar, pinataConfig);
    }

    private void updateViewerList(LivingEntity pinata, BossBar bar, PinataConfig.PinataConfiguration pinataConfig) {
        boolean global = pinataConfig.health.bar.global;
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (global || p.getWorld().equals((Object)pinata.getWorld())) {
                p.showBossBar(bar);
                continue;
            }
            p.hideBossBar(bar);
        }
    }

    private String formatTime(int seconds, PinataConfig.PinataConfiguration pinataConfig) {
        if (!pinataConfig.timer.timeout.enabled || seconds <= 0) {
            return "\u221e";
        }
        return String.format("%02d:%02d", seconds / 60, seconds % 60);
    }

    public boolean hasBossBar(UUID uuid) {
        return this.activeBossBars.containsKey(uuid);
    }

    public void removeBossBar(UUID uuid) {
        BossBar bar = this.activeBossBars.remove(uuid);
        if (bar != null) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                p.hideBossBar(bar);
            }
        }
    }

    public void removeAll() {
        this.activeBossBars.values().forEach(bar -> {
            for (Player p : Bukkit.getOnlinePlayers()) {
                p.hideBossBar(bar);
            }
        });
        this.activeBossBars.clear();
    }

    public Map<UUID, BossBar> getBossBars() {
        return this.activeBossBars;
    }
}

