/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.partyanimals.handler;

import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.maboroshi.partyanimals.PartyAnimals;
import org.maboroshi.partyanimals.config.ConfigManager;
import org.maboroshi.partyanimals.config.settings.PinataConfig;
import org.maboroshi.partyanimals.util.MessageUtils;

public class HitCooldownHandler {
    private final PartyAnimals plugin;
    private final ConfigManager config;
    private final MessageUtils messageUtils;

    public HitCooldownHandler(PartyAnimals plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfiguration();
        this.messageUtils = plugin.getMessageUtils();
    }

    public boolean isOnCooldown(Player player, LivingEntity pinata) {
        PinataConfig.PinataConfiguration pinataConfig = this.plugin.getPinataManager().getPinataConfig(pinata);
        PinataConfig.HitCooldown cooldownConfig = pinataConfig.interaction.hitCooldown;
        double cooldownSeconds = cooldownConfig.duration;
        if (cooldownSeconds <= 0.0) {
            return false;
        }
        boolean global = cooldownConfig.global;
        long now = System.currentTimeMillis();
        LivingEntity target = global ? pinata : player;
        NamespacedKey key = this.plugin.getPinataManager().getCooldownKey();
        long nextHit = (Long)target.getPersistentDataContainer().getOrDefault(key, PersistentDataType.LONG, (Object)0L);
        if (now < nextHit) {
            this.sendCooldownMessage(player, nextHit - now, pinataConfig);
            return true;
        }
        return false;
    }

    public void applyCooldown(Player player, LivingEntity pinata) {
        PinataConfig.PinataConfiguration pinataConfig = this.plugin.getPinataManager().getPinataConfig(pinata);
        PinataConfig.HitCooldown cooldownConfig = pinataConfig.interaction.hitCooldown;
        double cooldownSeconds = cooldownConfig.duration;
        if (cooldownSeconds <= 0.0) {
            return;
        }
        boolean global = cooldownConfig.global;
        long cooldownMillis = (long)(cooldownSeconds * 1000.0);
        long now = System.currentTimeMillis();
        LivingEntity target = global ? pinata : player;
        NamespacedKey key = this.plugin.getPinataManager().getCooldownKey();
        target.getPersistentDataContainer().set(key, PersistentDataType.LONG, (Object)(now + cooldownMillis));
    }

    private void sendCooldownMessage(Player player, long remainingMillis, PinataConfig.PinataConfiguration pinataConfig) {
        String msg = this.config.getMessageConfig().pinata.gameplay.hitCooldown;
        if (msg == null || msg.isEmpty()) {
            return;
        }
        double remainingSeconds = (double)remainingMillis / 1000.0;
        Component component = this.messageUtils.parse((Audience)player, msg, this.messageUtils.tag("countdown", String.format("%.1f", remainingSeconds)));
        String displayType = pinataConfig.interaction.hitCooldown.notificationType;
        switch (displayType.toLowerCase()) {
            case "action_bar": 
            case "actionbar": {
                player.sendActionBar(component);
                break;
            }
            default: {
                player.sendMessage(component);
            }
        }
    }
}

