/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.partyanimals.command.subcommands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.maboroshi.partyanimals.PartyAnimals;
import org.maboroshi.partyanimals.config.ConfigManager;
import org.maboroshi.partyanimals.util.MessageUtils;

public class ReloadCommand {
    private final PartyAnimals plugin;
    private final ConfigManager config;
    private final MessageUtils messageUtils;

    public ReloadCommand(PartyAnimals plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfiguration();
        this.messageUtils = plugin.getMessageUtils();
    }

    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(sender -> sender.getSender().hasPermission("partyanimals.reload"))).executes(ctx -> {
            CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
            if (this.plugin.reload()) {
                this.plugin.getPluginLogger().info("Configuration reloaded by " + sender.getName());
                this.messageUtils.send((Audience)sender, this.config.getMessageConfig().general.reloadSuccess, new TagResolver[0]);
            } else {
                this.plugin.getPluginLogger().warn("Failed to reload configuration by " + sender.getName());
                this.messageUtils.send((Audience)sender, this.config.getMessageConfig().general.reloadFail, new TagResolver[0]);
            }
            return 1;
        });
    }
}

