/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.partyanimals.util;

import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.maboroshi.partyanimals.config.ConfigManager;

public class MessageUtils {
    private final ConfigManager config;
    private final MiniMessage mm;
    private final boolean hasPAPI;

    public MessageUtils(ConfigManager config) {
        this.config = config;
        this.mm = MiniMessage.miniMessage();
        this.hasPAPI = Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI");
    }

    public Component parse(Audience receiver, String message, TagResolver ... tags) {
        String prefix;
        if (message == null || message.isEmpty()) {
            return Component.empty();
        }
        String parsedMessage = message;
        if (this.hasPAPI && receiver instanceof Player) {
            Player player = (Player)receiver;
            parsedMessage = PlaceholderAPI.setPlaceholders((Player)player, (String)parsedMessage);
        }
        TagResolver.Single prefixTag = Placeholder.parsed((String)"prefix", (String)((prefix = this.config.getMessageConfig().prefix) != null ? prefix : ""));
        TagResolver defaultTags = TagResolver.empty();
        if (receiver instanceof Player) {
            Player player = (Player)receiver;
            defaultTags = Placeholder.unparsed((String)"player", (String)player.getName());
        }
        TagResolver finalResolver = TagResolver.resolver((TagResolver[])new TagResolver[]{TagResolver.resolver((TagResolver[])tags), defaultTags, prefixTag});
        return this.mm.deserialize(parsedMessage, finalResolver);
    }

    public void send(Audience receiver, String message, TagResolver ... tags) {
        if (message == null || message.isEmpty()) {
            return;
        }
        receiver.sendMessage(this.parse(receiver, message, tags));
    }

    public TagResolver tag(String key, Object value) {
        return Placeholder.unparsed((String)key, (String)String.valueOf(value));
    }

    public TagResolver tagParsed(String key, String value) {
        return Placeholder.parsed((String)key, (String)value);
    }
}

