/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.partyanimals.config.settings;

import de.exlll.configlib.Comment;
import de.exlll.configlib.ConfigLib;
import de.exlll.configlib.Configuration;
import de.exlll.configlib.NameFormatter;
import de.exlll.configlib.NameFormatters;
import de.exlll.configlib.YamlConfigurationProperties;
import de.exlll.configlib.YamlConfigurations;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.bossbar.BossBar;
import org.bukkit.entity.Display;
import org.bukkit.entity.TextDisplay;
import org.maboroshi.partyanimals.config.objects.EffectTypes;
import org.maboroshi.partyanimals.config.objects.NameTagSettings;
import org.maboroshi.partyanimals.config.objects.RewardAction;

public final class PinataConfig {
    public static PinataConfiguration load(File pinataFile) {
        YamlConfigurationProperties properties = ((YamlConfigurationProperties.Builder)ConfigLib.BUKKIT_DEFAULT_PROPERTIES.toBuilder().setNameFormatter((NameFormatter)NameFormatters.LOWER_KEBAB_CASE)).build();
        return (PinataConfiguration)YamlConfigurations.update((Path)pinataFile.toPath(), PinataConfiguration.class, (YamlConfigurationProperties)properties);
    }

    @Configuration
    public static class PinataConfiguration {
        public Appearance appearance = new Appearance();
        public HealthSettings health = new HealthSettings();
        public InteractionSettings interaction = new InteractionSettings();
        public TimerSettings timer = new TimerSettings();
        public BehaviorSettings behavior = new BehaviorSettings();
        public EventRegistry events = new EventRegistry();
    }

    @Configuration
    public static class EventRegistry {
        @Comment(value={"Triggered when pinata spawns."})
        public GameEvent spawn = new GameEvent(true, new EffectTypes.EffectGroup(Map.of("twinkle", new EffectTypes.SoundEffect("entity.firework_rocket.twinkle", 1.0f, 1.0f)), Map.of("totem", new EffectTypes.ParticleEffect("TOTEM_OF_UNDYING", 10, new EffectTypes.ParticleOffset(0.5, 1.0, 0.5), 0.1))), new HashMap<String, RewardAction>(Map.of("announce", new RewardAction(100.0, List.of("say <green>A pinata has arrived!")))));
        @Comment(value={"Triggered when pinata is damaged."})
        public GameEvent hit = new GameEvent(true, new EffectTypes.EffectGroup(Map.of("crit-sound", new EffectTypes.SoundEffect("entity.player.attack.crit", 1.0f, 1.0f)), Map.of("crit-particle", new EffectTypes.ParticleEffect("CRIT", 5, new EffectTypes.ParticleOffset(0.3, 1.0, 0.3), 0.0))), new HashMap<String, RewardAction>(Map.of("vip_reward", new RewardAction(50.0, false, false, false, "partyanimals.vip", List.of("give <player> diamond 1")))));
        @Comment(value={"Triggered on the final killing blow."})
        public GameEvent lastHit = new GameEvent(false, new EffectTypes.EffectGroup(Map.of("challenge-complete", new EffectTypes.SoundEffect("ui.toast.challenge_complete", 1.0f, 1.0f)), Map.of("hearts", new EffectTypes.ParticleEffect("HEART", 20, new EffectTypes.ParticleOffset(0.0, 0.0, 0.0), 0.0))), new HashMap<String, RewardAction>());
        @Comment(value={"Triggered when pinata dies."})
        public GameEvent death = new GameEvent(true, new EffectTypes.EffectGroup(Map.of("explosion-sound", new EffectTypes.SoundEffect("entity.generic.explode", 1.0f, 1.0f)), Map.of("explosion-particle", new EffectTypes.ParticleEffect("EXPLOSION", 5, new EffectTypes.ParticleOffset(0.0, 0.0, 0.0), 0.0))), new HashMap<String, RewardAction>(Map.of("everyone_emerald", new RewardAction(100.0, false, false, false, "", List.of("give @a emerald 5")))));
    }

    @Configuration
    public static class GameEvent {
        @Comment(value={"Enable this event."})
        public boolean enabled = true;
        @Comment(value={"Visual/Audio effects."})
        public EffectTypes.EffectGroup effects = new EffectTypes.EffectGroup();
        @Comment(value={"Rewards to give. Key is the internal ID of the reward."})
        public Map<String, RewardAction> rewards = new HashMap<String, RewardAction>();

        public GameEvent() {
        }

        public GameEvent(boolean enabled, EffectTypes.EffectGroup effects, Map<String, RewardAction> rewards) {
            this.enabled = enabled;
            this.effects = effects;
            this.rewards = rewards;
        }
    }

    @Configuration
    public static class PhaseSettings {
        @Comment(value={"Duration in seconds."})
        public int duration = 10;
        @Comment(value={"Boss bar for this phase."})
        public BossBarSettings bar = new BossBarSettings();
        @Comment(value={"Effects at start of phase."})
        public EffectTypes.EffectGroup start = new EffectTypes.EffectGroup();
        @Comment(value={"Effects during phase."})
        public EffectTypes.EffectGroup mid = new EffectTypes.EffectGroup();
        @Comment(value={"Effects at end of phase."})
        public EffectTypes.EffectGroup end = new EffectTypes.EffectGroup();

        public PhaseSettings() {
        }

        public PhaseSettings(int duration, BossBarSettings bar, EffectTypes.EffectGroup start, EffectTypes.EffectGroup mid, EffectTypes.EffectGroup end) {
            this.duration = duration;
            this.bar = bar;
            this.start = start;
            this.mid = mid;
            this.end = end;
        }
    }

    @Configuration
    public static class BehaviorSettings {
        @Comment(value={"If false, the pinata acts like a statue."})
        public boolean enabled = true;
        @Comment(value={"Resistance to being pushed.", "Range: 0.0 to 1.0"})
        public double knockbackResistance = 1.0;
        @Comment(value={"Movement logic settings."})
        public MovementSettings movement = new MovementSettings("FLEE", new PathfindingRange(15.0, 5.0, 15.0), 1.75);
        @Comment(value={"Defensive reactions to being attacked or stuck."})
        public ReflexSettings reflexes = new ReflexSettings();
    }

    @Configuration
    public static class ReflexSettings {
        @Comment(value={"Shockwave settings."})
        public ShockwaveReflex shockwave = new ShockwaveReflex();
        @Comment(value={"Morph settings."})
        public MorphReflex morph = new MorphReflex();
        @Comment(value={"Blink settings."})
        public BlinkReflex blink = new BlinkReflex();
        @Comment(value={"Leap settings."})
        public LeapReflex leap = new LeapReflex();
        @Comment(value={"Sugar Rush settings."})
        public SugarRushReflex sugarRush = new SugarRushReflex();
        @Comment(value={"Dazzle settings."})
        public DazzleReflex dazzle = new DazzleReflex();
    }

    @Configuration
    public static class DazzleReflex {
        public boolean enabled = true;
        @Comment(value={"Chance to trigger when hit."})
        public double chance = 20.0;
        @Comment(value={"Duration of blindness (ticks)."})
        public int duration = 30;
        @Comment(value={"Visual/Audio effects.", "These apply to the players' view."})
        public EffectTypes.EffectGroup effects = new EffectTypes.EffectGroup(Map.of(), Map.of("blind-flash", new EffectTypes.ParticleEffect("GLOW", 10, new EffectTypes.ParticleOffset(0.2, 0.2, 0.2), 0.1)));
        @Comment(value={"Commands to execute when triggered."})
        public Map<String, RewardAction> commands = new HashMap<String, RewardAction>();
    }

    @Configuration
    public static class SugarRushReflex {
        public boolean enabled = true;
        @Comment(value={"Chance to trigger when hit."})
        public double chance = 20.0;
        @Comment(value={"Duration of speed burst (ticks)."})
        public int duration = 40;
        @Comment(value={"Speed level (0 = Speed I, 1 = Speed II, 2 = Speed III)."})
        public int amplifier = 2;
        @Comment(value={"Visual/Audio effects."})
        public EffectTypes.EffectGroup effects = new EffectTypes.EffectGroup();
        @Comment(value={"Commands to execute when triggered."})
        public Map<String, RewardAction> commands = new HashMap<String, RewardAction>();
    }

    @Configuration
    public static class LeapReflex {
        public boolean enabled = true;
        @Comment(value={"Chance to trigger on hit."})
        public double chance = 20.0;
        @Comment(value={"Strength multiplier."})
        public double strength = 1.0;
        @Comment(value={"Visual/Audio effects."})
        public EffectTypes.EffectGroup effects = new EffectTypes.EffectGroup();
        @Comment(value={"Commands to execute when triggered."})
        public Map<String, RewardAction> commands = new HashMap<String, RewardAction>();
    }

    @Configuration
    public static class BlinkReflex {
        public boolean enabled = true;
        @Comment(value={"Chance to trigger on hit."})
        public double chance = 10.0;
        @Comment(value={"Teleportation distance in blocks."})
        public double distance = 10.0;
        @Comment(value={"If true, y-coordinates are ignored from the teleportation calculation."})
        public boolean ignoreYLevel = true;
        @Comment(value={"Visual/Audio effects."})
        public EffectTypes.EffectGroup effects = new EffectTypes.EffectGroup();
        @Comment(value={"Commands to execute when triggered."})
        public Map<String, RewardAction> commands = new HashMap<String, RewardAction>();
    }

    @Configuration
    public static class MorphReflex {
        public boolean enabled = true;
        @Comment(value={"Chance to trigger on hit."})
        public double chance = 20.0;
        @Comment(value={"Duration in ticks."})
        public int duration = 60;
        @Comment(value={"Toggle whether to morph into a different age or scale randomly.", "Options: AGE, SCALE"})
        public String type = "AGE";
        @Comment(value={"Scale settings.", "Set 'type' to SCALE to use these. If both scale values are the same, a fixed size is used."})
        public ScaleSettings scale = new ScaleSettings(0.5, 1.5);
        @Comment(value={"Visual/Audio effects."})
        public EffectTypes.EffectGroup effects = new EffectTypes.EffectGroup();
        @Comment(value={"Commands to execute when triggered."})
        public Map<String, RewardAction> commands = new HashMap<String, RewardAction>();
    }

    @Configuration
    public static class ShockwaveReflex {
        public boolean enabled = true;
        @Comment(value={"Chance to trigger on hit."})
        public double chance = 20.0;
        @Comment(value={"Strength multiplier."})
        public double strength = 1.5;
        @Comment(value={"Vertical boost applied to affected players."})
        public double verticalBoost = 0.5;
        @Comment(value={"Radius in blocks to find players to affect."})
        public double radius = 5.0;
        @Comment(value={"Visual/Audio effects."})
        public EffectTypes.EffectGroup effects = new EffectTypes.EffectGroup();
        @Comment(value={"Commands to execute when triggered."})
        public Map<String, RewardAction> commands = new HashMap<String, RewardAction>();
    }

    @Configuration
    public static class MovementSettings {
        @Comment(value={"Active movement type.", "Options: ROAM, FLEE, BOTH, NONE"})
        public String type = "FLEE";
        @Comment(value={"Radius for random movement."})
        public PathfindingRange radius = new PathfindingRange(15.0, 5.0, 15.0);
        @Comment(value={"Movement speed multiplier."})
        public double speed = 1.75;

        public MovementSettings() {
        }

        public MovementSettings(String type, PathfindingRange radius, double speed) {
            this.type = type;
            this.radius = radius;
            this.speed = speed;
        }
    }

    @Configuration
    public static class PathfindingRange {
        public double x = 15.0;
        public double y = 5.0;
        public double z = 15.0;

        public PathfindingRange() {
        }

        public PathfindingRange(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }

    @Configuration
    public static class TimerSettings {
        @Comment(value={"Countdown before the pinata spawns."})
        public PhaseSettings countdown = new PhaseSettings(10, new BossBarSettings(true, true, BossBar.Color.YELLOW, BossBar.Overlay.PROGRESS, "A pinata party will begin in <white><countdown></white>. Get ready!"), new EffectTypes.EffectGroup(Map.of("tick", new EffectTypes.SoundEffect("block.note_block.bit", 1.0f, 1.0f)), Map.of("spawn-flare", new EffectTypes.ParticleEffect("FIREWORK", 5, new EffectTypes.ParticleOffset(0.0, 0.0, 0.0), 0.0))), new EffectTypes.EffectGroup(Map.of("pulse", new EffectTypes.SoundEffect("block.note_block.bit", 1.0f, 0.8f)), Map.of("note-trail", new EffectTypes.ParticleEffect("NOTE", 5, new EffectTypes.ParticleOffset(0.0, 0.0, 0.0), 0.0))), new EffectTypes.EffectGroup(Map.of("launch", new EffectTypes.SoundEffect("entity.firework_rocket.launch", 1.0f, 0.8f)), Map.of("boom", new EffectTypes.ParticleEffect("SONIC_BOOM", 5, new EffectTypes.ParticleOffset(0.0, 0.0, 0.0), 0.0))));
        @Comment(value={"Maximum time to kill the pinata."})
        public TimeoutSettings timeout = new TimeoutSettings(true, 300);
    }

    @Configuration
    public static class TimeoutSettings {
        @Comment(value={"Enable despawning if not killed in time."})
        public boolean enabled = true;
        @Comment(value={"Seconds before despawning."})
        public int duration = 300;

        public TimeoutSettings() {
        }

        public TimeoutSettings(boolean enabled, int duration) {
            this.enabled = enabled;
            this.duration = duration;
        }
    }

    @Configuration
    public static class InteractionSettings {
        @Comment(value={"Permission required to hit the pinata."})
        public String permission = "";
        @Comment(value={"Item restriction settings."})
        public ItemWhitelist allowedItems = new ItemWhitelist(false, Set.of("STICK", "BLAZE_ROD"));
        @Comment(value={"Anti-spam click settings."})
        public HitCooldown hitCooldown = new HitCooldown(true, 0.75, false, "ACTION_BAR");
    }

    @Configuration
    public static class HitCooldown {
        @Comment(value={"Enable attack speed limits."})
        public boolean enabled = true;
        @Comment(value={"Seconds between hits."})
        public double duration = 0.75;
        @Comment(value={"If true, the cooldown is global (all players share the timer)."})
        public boolean global = false;
        @Comment(value={"Feedback type.", "Options: ACTION_BAR, CHAT"})
        public String notificationType = "ACTION_BAR";

        public HitCooldown() {
        }

        public HitCooldown(boolean enabled, double duration, boolean global, String notificationType) {
            this.enabled = enabled;
            this.duration = duration;
            this.global = global;
            this.notificationType = notificationType;
        }
    }

    @Configuration
    public static class ItemWhitelist {
        @Comment(value={"Only allow specific items to deal damage."})
        public boolean enabled = false;
        @Comment(value={"List of allowed material names.", "See: https://jd.papermc.io/paper/1.21.11/org/bukkit/Material.html"})
        public Set<String> materialNames = Set.of("STICK", "BLAZE_ROD");

        public ItemWhitelist() {
        }

        public ItemWhitelist(boolean enabled, Set<String> materialNames) {
            this.enabled = enabled;
            this.materialNames = materialNames;
        }
    }

    @Configuration
    public static class HealthSettings {
        @Comment(value={"Base health points."})
        public int baseHealth = 5;
        @Comment(value={"If true, health is multiplied according to player count."})
        public boolean perPlayer = true;
        @Comment(value={"Maximum health points."})
        public int maxHealth = 250;
        @Comment(value={"Health bar visual settings."})
        public BossBarSettings bar = new BossBarSettings(true, true, BossBar.Color.GREEN, BossBar.Overlay.NOTCHED_10, "<pinata> <health> <gray>/</gray> <max-health> <red>\u2764</red> <gray>[<timer>]</gray>");
    }

    @Configuration
    public static class BossBarSettings {
        @Comment(value={"Show a boss bar for this phase."})
        public boolean enabled = true;
        @Comment(value={"If true, all players see the bar. If false, only those near the pinata."})
        public boolean global = true;
        @Comment(value={"Bar color.", "See: https://jd.advntr.dev/api/4.25.0/net/kyori/adventure/bossbar/BossBar.Color.html"})
        public BossBar.Color color = BossBar.Color.PURPLE;
        @Comment(value={"Bar overlay.", "See: https://jd.advntr.dev/api/4.25.0/net/kyori/adventure/bossbar/BossBar.Overlay.html"})
        public BossBar.Overlay overlay = BossBar.Overlay.PROGRESS;
        @Comment(value={"Text displayed on the boss bar."})
        public String text = "";

        public BossBarSettings() {
        }

        public BossBarSettings(boolean enabled, boolean global, BossBar.Color color, BossBar.Overlay overlay, String text) {
            this.enabled = enabled;
            this.global = global;
            this.color = color;
            this.overlay = overlay;
            this.text = text;
        }
    }

    @Configuration
    public static class Appearance {
        @Comment(value={"Entity types to use for the pinata.", "If multiple types are provided, one is chosen randomly.", "See: https://jd.papermc.io/paper/1.21.11/org/bukkit/entity/EntityType.html"})
        public List<String> entityTypes = List.of("LLAMA", "MULE");
        @Comment(value={"Custom name of the pinata entity."})
        public String name = "<gradient:#FF5555:#FF55FF>\ud83e\ude85 <bold>Party Pinata</bold></gradient>";
        @Comment(value={"Custom name displayed above the pinata."})
        public NameTagSettings nameTag = new NameTagSettings(true, "TEXT", List.of("<pinata>", "<health> <gray>/</gray> <max-health> <red>\u2764</red>", "<timer>"), TextDisplay.TextAlignment.CENTER, new NameTagSettings.BackgroundSettings(false, 64, 0, 0, 0), new NameTagSettings.TextShadowSettings(true, 0.0f, 0.0f), Display.Billboard.VERTICAL, true, 20, new NameTagSettings.TransformSettings(new NameTagSettings.TranslationSettings(0.0, 0.5, 0.0), new NameTagSettings.ScaleSettings(1.0, 1.0, 1.0)));
        @Comment(value={"Size randomization settings."})
        public ScaleSettings scale = new ScaleSettings(0.75, 1.25);
        @Comment(value={"Flash red when taking damage."})
        public boolean damageFlash = false;
        @Comment(value={"Show glowing outline."})
        public boolean glowing = true;
        @Comment(value={"Color of the glowing outline."})
        public String glowColor = "LIGHT_PURPLE";
    }

    @Configuration
    public static class ScaleSettings {
        @Comment(value={"Minimum size multiplier."})
        public double min = 0.75;
        @Comment(value={"Maximum size multiplier."})
        public double max = 1.25;

        public ScaleSettings() {
        }

        public ScaleSettings(double min, double max) {
            this.min = min;
            this.max = max;
        }
    }
}

