/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.partyanimals.behavior;

import com.destroystokyo.paper.entity.Pathfinder;
import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import java.util.EnumSet;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.maboroshi.partyanimals.PartyAnimals;
import org.maboroshi.partyanimals.config.settings.PinataConfig;

public class PinataFleeGoal
implements Goal<Mob> {
    private final PinataConfig.PinataConfiguration config;
    private final Mob mob;
    private final double speed;
    private final double checkRadius;
    private Player targetPlayer;
    private final GoalKey<Mob> key;

    public PinataFleeGoal(PartyAnimals plugin, Mob mob) {
        this.mob = mob;
        this.config = plugin.getPinataManager().getPinataConfig((LivingEntity)mob);
        this.speed = this.config.behavior.movement.speed;
        this.checkRadius = Math.max(this.config.behavior.movement.radius.x, 5.0);
        this.key = GoalKey.of(Mob.class, (NamespacedKey)new NamespacedKey((Plugin)plugin, "pinata_flee"));
    }

    public boolean shouldActivate() {
        this.targetPlayer = null;
        double closestDist = Double.MAX_VALUE;
        for (Player p : this.mob.getWorld().getPlayers()) {
            double distSq;
            if (p.getGameMode() == GameMode.SPECTATOR || p.getGameMode() == GameMode.CREATIVE || p.getLocation().distanceSquared(this.mob.getLocation()) > this.checkRadius * this.checkRadius || !((distSq = p.getLocation().distanceSquared(this.mob.getLocation())) < this.checkRadius * this.checkRadius) || !(distSq < closestDist)) continue;
            closestDist = distSq;
            this.targetPlayer = p;
        }
        return this.targetPlayer != null;
    }

    public boolean shouldStayActive() {
        if (this.targetPlayer == null || !this.targetPlayer.isValid()) {
            return false;
        }
        Pathfinder.PathResult path = this.mob.getPathfinder().getCurrentPath();
        if (path == null || path.getNextPoint() == null) {
            return false;
        }
        return this.mob.getLocation().distanceSquared(this.targetPlayer.getLocation()) < this.checkRadius * this.checkRadius * 1.5;
    }

    public void start() {
        this.runAway();
    }

    public void tick() {
        if (this.mob.getTicksLived() % 10 == 0) {
            this.runAway();
        }
    }

    private void runAway() {
        if (this.targetPlayer == null) {
            return;
        }
        Vector direction = this.mob.getLocation().toVector().subtract(this.targetPlayer.getLocation().toVector());
        if (direction.lengthSquared() < 0.01) {
            direction = new Vector(1, 0, 0);
        } else {
            direction.normalize();
        }
        Location targetLoc = this.mob.getLocation().add(direction.multiply(5));
        targetLoc.setY(this.mob.getLocation().getY());
        if (this.isSafeLocation(targetLoc)) {
            this.mob.getPathfinder().moveTo(targetLoc, this.speed);
        }
    }

    private boolean isSafeLocation(Location location) {
        if (!location.getBlock().isPassable()) {
            return false;
        }
        double currentHeight = this.mob.getHeight();
        int blocksToCheck = (int)Math.ceil(currentHeight);
        for (int i = 1; i < blocksToCheck; ++i) {
            if (location.clone().add(0.0, (double)i, 0.0).getBlock().isPassable()) continue;
            return false;
        }
        return true;
    }

    public GoalKey<Mob> getKey() {
        return this.key;
    }

    public EnumSet<GoalType> getTypes() {
        return EnumSet.of(GoalType.MOVE);
    }
}

