/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.partyanimals.listener;

import com.destroystokyo.paper.event.entity.EntityAddToWorldEvent;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.maboroshi.partyanimals.PartyAnimals;
import org.maboroshi.partyanimals.api.event.pinata.PinataDeathEvent;
import org.maboroshi.partyanimals.api.event.pinata.PinataHitEvent;
import org.maboroshi.partyanimals.config.ConfigManager;
import org.maboroshi.partyanimals.config.settings.PinataConfig;
import org.maboroshi.partyanimals.handler.EffectHandler;
import org.maboroshi.partyanimals.handler.HitCooldownHandler;
import org.maboroshi.partyanimals.handler.ReflexHandler;
import org.maboroshi.partyanimals.handler.RewardHandler;
import org.maboroshi.partyanimals.manager.BossBarManager;
import org.maboroshi.partyanimals.manager.PinataManager;
import org.maboroshi.partyanimals.util.Logger;
import org.maboroshi.partyanimals.util.MessageUtils;

public class PinataListener
implements Listener {
    private final PartyAnimals plugin;
    private final Logger log;
    private final ConfigManager config;
    private final MessageUtils messageUtils;
    private final PinataManager pinataManager;
    private final BossBarManager bossBarManager;
    private final HitCooldownHandler hitCooldownHandler;
    private final EffectHandler effectHandler;
    private final RewardHandler rewardHandler;
    private final ReflexHandler reflexHandler;

    public PinataListener(PartyAnimals plugin) {
        this.plugin = plugin;
        this.log = plugin.getPluginLogger();
        this.config = plugin.getConfiguration();
        this.messageUtils = plugin.getMessageUtils();
        this.pinataManager = plugin.getPinataManager();
        this.bossBarManager = plugin.getBossBarManager();
        this.hitCooldownHandler = plugin.getHitCooldownHandler();
        this.effectHandler = plugin.getEffectHandler();
        this.rewardHandler = plugin.getRewardHandler();
        this.reflexHandler = plugin.getReflexHandler();
    }

    @EventHandler
    public void onPinataLoad(EntityAddToWorldEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity pinata = (LivingEntity)entity;
        if (!this.pinataManager.isPinata(pinata)) {
            return;
        }
        pinata.getScheduler().run((Plugin)this.plugin, task -> {
            if (pinata.isValid()) {
                this.log.debug("Restoring pinata state: " + String.valueOf(pinata.getUniqueId()));
                this.pinataManager.activatePinata(pinata);
            }
        }, null);
    }

    @EventHandler
    public void onPinataInteract(PlayerInteractEntityEvent event) {
        LivingEntity pinata;
        Entity entity = event.getRightClicked();
        if (entity instanceof LivingEntity && this.pinataManager.isPinata(pinata = (LivingEntity)entity)) {
            this.log.debug("Player attempted to interact with a pinata: " + String.valueOf(pinata));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPinataHit(EntityDamageByEntityEvent event) {
        LivingEntity pinata;
        if (this.plugin.getPinataManager() == null) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity) || !this.pinataManager.isPinata(pinata = (LivingEntity)entity)) {
            return;
        }
        Entity entity2 = event.getDamager();
        if (!(entity2 instanceof Player)) {
            this.log.debug("Non-player entity attempted to damage pinata: " + String.valueOf(pinata));
            event.setCancelled(true);
            return;
        }
        Player player = (Player)entity2;
        PinataConfig.PinataConfiguration pinataConfig = this.pinataManager.getPinataConfig(pinata);
        if (!this.checkPermission(player, pinataConfig)) {
            this.log.debug("Player " + player.getName() + " does not have permission to hit pinatas.");
            event.setCancelled(true);
            return;
        }
        if (!this.isItemAllowed(player, pinataConfig.interaction.allowedItems)) {
            this.log.debug("Player " + player.getName() + " attempted to hit pinata " + String.valueOf(pinata) + " with disallowed item.");
            event.setCancelled(true);
            return;
        }
        if (this.hitCooldownHandler.isOnCooldown(player, pinata)) {
            this.log.debug("Player " + player.getName() + " attempted to hit pinata " + String.valueOf(pinata) + " but is on cooldown.");
            event.setCancelled(true);
            return;
        }
        this.hitCooldownHandler.applyCooldown(player, pinata);
        this.reflexHandler.onDamage(pinata, player, pinataConfig);
        PinataHitEvent hitEvent = new PinataHitEvent(pinata, player);
        this.plugin.getServer().getPluginManager().callEvent((Event)hitEvent);
        if (hitEvent.isCancelled()) {
            return;
        }
        event.setCancelled(true);
        int currentHits = (Integer)pinata.getPersistentDataContainer().getOrDefault(this.pinataManager.getHealthKey(), PersistentDataType.INTEGER, (Object)1);
        this.log.debug("Pinata " + String.valueOf(pinata) + " (UUID: " + String.valueOf(pinata.getUniqueId()) + ") hit by player " + player.getName() + ". Remaining hits: " + --currentHits);
        if (currentHits <= 0) {
            this.handlePinataDeath(pinata, player, pinataConfig);
        } else {
            pinata.getPersistentDataContainer().set(this.pinataManager.getHealthKey(), PersistentDataType.INTEGER, (Object)currentHits);
            this.effectHandler.playEffects(pinataConfig.events.hit.effects, pinata.getLocation(), false);
            if (pinataConfig.appearance.damageFlash) {
                pinata.playHurtAnimation(0.0f);
            }
            this.log.debug("Processing hit commands for player: " + player.getName());
            this.rewardHandler.process((OfflinePlayer)player, pinataConfig.events.hit.rewards.values());
            String hitMessage = this.config.getMessageConfig().pinata.gameplay.hitSuccess;
            if (hitMessage != null && !hitMessage.isEmpty()) {
                this.messageUtils.send((Audience)player, hitMessage, new TagResolver[0]);
            }
            NamespacedKey maxHealthKey = this.pinataManager.getMaxHealthKey();
            int actualMaxHealth = (Integer)pinata.getPersistentDataContainer().getOrDefault(maxHealthKey, PersistentDataType.INTEGER, (Object)currentHits);
            this.bossBarManager.updateBossBar(pinata, currentHits, actualMaxHealth, this.pinataManager.getSpawnTimeKey(), pinataConfig);
        }
    }

    @EventHandler
    public void onPinataDamage(EntityDamageEvent event) {
        LivingEntity pinata;
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity) || !this.pinataManager.isPinata(pinata = (LivingEntity)entity)) {
            return;
        }
        if (event.getCause() != EntityDamageEvent.DamageCause.ENTITY_ATTACK && event.getCause() != EntityDamageEvent.DamageCause.PROJECTILE) {
            this.log.debug("Pinata " + String.valueOf(pinata) + " (UUID: " + String.valueOf(pinata.getUniqueId()) + ") attempted to take non-player damage: " + String.valueOf(event.getCause()));
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.bossBarManager.getBossBars().values().forEach(arg_0 -> ((Player)player).showBossBar(arg_0));
    }

    private boolean checkPermission(Player player, PinataConfig.PinataConfiguration pinataConfig) {
        String permission = pinataConfig.interaction.permission;
        if (permission == null || permission.isEmpty()) {
            return true;
        }
        if (!player.hasPermission(permission)) {
            String noPermission = this.config.getMessageConfig().pinata.gameplay.hitNoPermission;
            if (noPermission != null && !noPermission.isEmpty()) {
                this.messageUtils.send((Audience)player, noPermission, new TagResolver[0]);
            }
            return false;
        }
        return true;
    }

    private boolean isItemAllowed(Player player, PinataConfig.ItemWhitelist allowedItems) {
        if (!allowedItems.enabled || allowedItems.materialNames == null || allowedItems.materialNames.isEmpty()) {
            return true;
        }
        Material heldMaterial = player.getInventory().getItemInMainHand().getType();
        boolean isAllowed = false;
        for (String configName : allowedItems.materialNames) {
            Material targetMaterial = Material.matchMaterial((String)configName);
            if (targetMaterial == null || targetMaterial != heldMaterial) continue;
            isAllowed = true;
            break;
        }
        if (!isAllowed) {
            String allowedItemsMessage = this.config.getMessageConfig().pinata.gameplay.hitWrongItem;
            if (allowedItemsMessage != null && !allowedItemsMessage.isEmpty()) {
                this.messageUtils.send((Audience)player, allowedItemsMessage, this.messageUtils.tag("item", heldMaterial.name()));
            }
            return false;
        }
        return true;
    }

    private void handlePinataDeath(LivingEntity pinata, Player player, PinataConfig.PinataConfiguration pinataConfig) {
        this.log.debug("Handling pinata death for pinata: " + String.valueOf(pinata) + " (UUID: " + String.valueOf(pinata.getUniqueId()) + ") by player: " + player.getName());
        PinataDeathEvent event = new PinataDeathEvent(pinata, player);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        this.effectHandler.playEffects(pinataConfig.events.death.effects, pinata.getLocation(), false);
        this.log.debug("Processing last hit commands...");
        this.rewardHandler.process((OfflinePlayer)player, pinataConfig.events.lastHit.rewards.values());
        String lastHitMessage = this.config.getMessageConfig().pinata.gameplay.lastHit;
        this.messageUtils.send((Audience)player, lastHitMessage, this.messageUtils.tag("player", player.getName()));
        this.log.debug("Processing death commands...");
        this.rewardHandler.process((OfflinePlayer)player, pinataConfig.events.death.rewards.values());
        String downedMessage = this.config.getMessageConfig().pinata.events.defeated;
        this.messageUtils.send((Audience)this.plugin.getServer(), downedMessage, this.messageUtils.tag("player", player.getName()));
        this.pinataManager.safelyRemovePinata(pinata);
    }
}

