/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.partyanimals.util;

import java.util.ArrayList;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.maboroshi.partyanimals.PartyAnimals;
import org.maboroshi.partyanimals.config.settings.MainConfig;

public class VoteReminder
implements Runnable {
    private final PartyAnimals plugin;

    public VoteReminder(PartyAnimals plugin) {
        this.plugin = plugin;
    }

    @Override
    public void run() {
        MainConfig.VoteReminderSettings settings = this.plugin.getConfiguration().getMainConfig().modules.vote.reminder;
        if (!settings.enabled) {
            return;
        }
        ArrayList onlinePlayers = new ArrayList(Bukkit.getOnlinePlayers());
        Bukkit.getAsyncScheduler().runNow((Plugin)this.plugin, task -> {
            long timeThreshold = System.currentTimeMillis() - 86400000L;
            for (Player player : onlinePlayers) {
                int recentVotes = this.plugin.getDatabaseManager().getVotesSince(player.getUniqueId(), timeThreshold);
                if (recentVotes > 0) continue;
                player.getScheduler().run((Plugin)this.plugin, st -> {
                    if (player.isOnline()) {
                        this.plugin.getEffectHandler().playEffects(settings.effects, player.getLocation(), false);
                        settings.message.forEach(msg -> this.plugin.getMessageUtils().send((Audience)player, (String)msg, new TagResolver[0]));
                    }
                }, null);
            }
        });
    }
}

