/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.partyanimals.config.settings;

import de.exlll.configlib.Comment;
import de.exlll.configlib.ConfigLib;
import de.exlll.configlib.Configuration;
import de.exlll.configlib.NameFormatter;
import de.exlll.configlib.NameFormatters;
import de.exlll.configlib.YamlConfigurationProperties;
import de.exlll.configlib.YamlConfigurations;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.maboroshi.partyanimals.config.objects.EffectTypes;
import org.maboroshi.partyanimals.config.objects.RewardAction;
import org.maboroshi.partyanimals.config.objects.SerializableLocation;

public final class MainConfig {
    public static MainConfiguration load(File dataFolder) {
        YamlConfigurationProperties properties = ((YamlConfigurationProperties.Builder)ConfigLib.BUKKIT_DEFAULT_PROPERTIES.toBuilder().setNameFormatter((NameFormatter)NameFormatters.LOWER_KEBAB_CASE)).build();
        Path configFile = new File(dataFolder, "config.yml").toPath();
        return (MainConfiguration)YamlConfigurations.update((Path)configFile, MainConfiguration.class, (YamlConfigurationProperties)properties);
    }

    @Configuration
    public static class MainConfiguration {
        @Comment(value={"Enable debug mode to see detailed logs in the console."})
        public boolean debug = false;
        @Comment(value={"Database settings."})
        public DatabaseSettings database = new DatabaseSettings();
        @Comment(value={"Control which parts of the plugin should be active."})
        public ModuleSettings modules = new ModuleSettings();
    }

    @Configuration
    public static class EventRegistry {
        @Comment(value={"Triggered when a single vote is received."})
        public VoteEvent playerVote = new VoteEvent();
    }

    @Configuration
    public static class VoteEvent {
        @Comment(value={"Enable this event."})
        public boolean enabled = true;
        @Comment(value={"Visual/Audio effects."})
        public EffectTypes.EffectGroup effects = new EffectTypes.EffectGroup(new HashMap<String, EffectTypes.SoundEffect>(Map.of("level-up", new EffectTypes.SoundEffect("entity.player.levelup", 1.0f, 1.0f))), new HashMap<String, EffectTypes.ParticleEffect>());
        @Comment(value={"Rewards to give."})
        public Map<String, RewardAction> rewards = new HashMap<String, RewardAction>(Map.of("announce", new RewardAction(100.0, List.of("say <green>Thank you {player} for voting!"))));
    }

    @Configuration
    public static class CommunityGoalSettings {
        @Comment(value={"Enable the community goal system?"})
        public boolean enabled = true;
        @Comment(value={"How many votes are needed to trigger the rewards?"})
        public int votesRequired = 50;
        @Comment(value={"Rewards to execute when the goal is reached."})
        public Map<String, RewardAction> rewards = new HashMap<String, RewardAction>();

        public CommunityGoalSettings() {
            this.rewards.put("community_reward", new RewardAction(100.0, List.of("say <green>Community goal reached!", "pa pinata start default default")));
        }
    }

    @Configuration
    public static class VoteReminderSettings {
        @Comment(value={"Enable or disable the vote reminders."})
        public boolean enabled = true;
        @Comment(value={"Interval in seconds (default 3 hours)."})
        public int interval = 10800;
        @Comment(value={"Message to send to players."})
        public List<String> message = List.of("<prefix> <yellow>Don't forget to vote for our server! <click:open_url:\"https://example.com/vote\"><u><blue>Click here to vote!</blue></u></click>");
        @Comment(value={"Visual/Audio effects."})
        public EffectTypes.EffectGroup effects = new EffectTypes.EffectGroup(new HashMap<String, EffectTypes.SoundEffect>(Map.of("notification", new EffectTypes.SoundEffect("block.note_block.pling", 1.0f, 1.0f))), new HashMap<String, EffectTypes.ParticleEffect>());
    }

    @Configuration
    public static class OfflineVoteSettings {
        @Comment(value={"Process votes even if the player is offline?"})
        public boolean enabled = true;
        @Comment(value={"If true, rewards are queued and given when the player joins. If false, rewards are given immediately."})
        public boolean queueRewards = true;
    }

    @Configuration
    public static class VoteSettings {
        @Comment(value={"Enable or disable the voting module."})
        public boolean enabled = false;
        @Comment(value={"Settings for handling offline votes."})
        public OfflineVoteSettings offline = new OfflineVoteSettings();
        @Comment(value={"Periodic reminders for players to vote."})
        public VoteReminderSettings reminder = new VoteReminderSettings();
        @Comment(value={"Community Goal settings."})
        public CommunityGoalSettings communityGoal = new CommunityGoalSettings();
        @Comment(value={"Event configurations for votes."})
        public EventRegistry events = new EventRegistry();
    }

    @Configuration
    public static class PinataSettings {
        @Comment(value={"Enable or disable the pinata module."})
        public boolean enabled = false;
        @Comment(value={"Defined spawn points."})
        public Map<String, SerializableLocation> spawnPoints = new HashMap<String, SerializableLocation>(Map.of("default", new SerializableLocation()));
    }

    @Configuration
    public static class ModuleSettings {
        @Comment(value={"Toggle the pinata module."})
        public PinataSettings pinata = new PinataSettings();
        @Comment(value={"Toggle the voting module."})
        public VoteSettings vote = new VoteSettings();
    }

    @Configuration
    public static class PoolSettings {
        @Comment(value={"Maximum number of concurrent connections (Default: 10)."})
        public int maximumPoolSize = 10;
        @Comment(value={"How long to wait for a connection in milliseconds (Default: 30000)."})
        public int connectionTimeout = 30000;
        @Comment(value={"Warn if a connection is held longer than this (Default: 10000)."})
        public int leakDetectionThreshold = 10000;
    }

    @Configuration
    public static class DatabaseSettings {
        @Comment(value={"Type of database: 'sqlite' or 'mysql' or 'mariadb'."})
        public String type = "sqlite";
        @Comment(value={"Hostname (for MySQL/MariaDB)."})
        public String host = "localhost";
        @Comment(value={"Port (default 3306 for MySQL/MariaDB)."})
        public int port = 3306;
        @Comment(value={"Database name."})
        public String database = "partyanimals";
        @Comment(value={"Username."})
        public String username = "root";
        @Comment(value={"Password."})
        public String password = "password";
        @Comment(value={"Prefix for tables (e.g., 'pa_votes')."})
        public String tablePrefix = "pa_";
        @Comment(value={"Advanced connection pool settings."})
        public PoolSettings pool = new PoolSettings();
    }
}

