/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.partyanimals.command.subcommands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.maboroshi.partyanimals.PartyAnimals;
import org.maboroshi.partyanimals.util.MessageUtils;

public class HelpCommand {
    private final PartyAnimals plugin;
    private final MessageUtils messageUtils;

    public HelpCommand(PartyAnimals plugin) {
        this.plugin = plugin;
        this.messageUtils = plugin.getMessageUtils();
    }

    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)Commands.literal((String)"help").executes(this::executeHelp);
    }

    private int executeHelp(CommandContext<CommandSourceStack> ctx) {
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        this.messageUtils.send((Audience)sender, this.plugin.getConfiguration().getMessageConfig().help.header, new TagResolver[0]);
        this.sendHelpLine(sender, "pa reload", "Reload configuration", "partyanimals.reload");
        this.sendHelpLine(sender, "pa pinata start <pinata> <loc>", "Start pinata countdown", "partyanimals.pinata.start");
        this.sendHelpLine(sender, "pa pinata spawn <pinata> <loc>", "Spawn pinata immediately", "partyanimals.pinata.spawn");
        this.sendHelpLine(sender, "pa pinata killall", "Remove all active pinatas", "partyanimals.pinata.killall");
        this.sendHelpLine(sender, "pa pinata spawnpoint add <name>", "Save current location", "partyanimals.pinata.spawnpoint.add");
        this.sendHelpLine(sender, "pa pinata spawnpoint remove <name>", "Remove saved location", "partyanimals.pinata.spawnpoint.remove");
        this.sendHelpLine(sender, "pa vote check <player>", "Check player votes", "partyanimals.vote.check");
        this.sendHelpLine(sender, "pa vote <add|remove|set>", "Modify vote data", "partyanimals.vote.add/remove/set");
        this.sendHelpLine(sender, "pa vote send", "Send a legitimate vote", "partyanimals.vote.send");
        this.sendHelpLine(sender, "pa vote test", "Send a fake vote", "partyanimals.vote.test");
        this.sendHelpLine(sender, "pa vote migrate <plugin>", "Migrate data from another plugin", "partyanimals.vote.migrate");
        return 1;
    }

    private void sendHelpLine(CommandSender sender, String command, String description, String permission) {
        if (permission != null && !sender.hasPermission(permission)) {
            return;
        }
        String format = this.plugin.getConfiguration().getMessageConfig().help.entry;
        this.messageUtils.send((Audience)sender, format, this.messageUtils.tag("command", command), this.messageUtils.tag("description", description));
    }
}

