/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.partyanimals.behavior;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import java.util.EnumSet;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.entity.Creature;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class PinataFloatGoal
implements Goal<Creature> {
    private final Creature mob;
    private final GoalKey<Creature> key;
    private Vector cachedLandDirection = null;
    private int cooldown = 0;

    public PinataFloatGoal(Plugin plugin, Creature mob) {
        this.mob = mob;
        this.key = GoalKey.of(Creature.class, (NamespacedKey)new NamespacedKey(plugin, "pinata_float"));
    }

    public boolean shouldActivate() {
        return this.mob.isInWater() || this.mob.getEyeLocation().getBlock().isLiquid();
    }

    public void tick() {
        if (ThreadLocalRandom.current().nextFloat() < 0.8f) {
            Vector velocity = this.mob.getVelocity();
            if (velocity.getY() < 0.1) {
                velocity.setY(0.15);
            }
            Vector dir = this.getDirectionToLand();
            dir = this.avoidWalls(dir);
            velocity.add(dir);
            this.mob.setVelocity(velocity);
            if (dir.getX() != 0.0 || dir.getZ() != 0.0) {
                Location loc = this.mob.getLocation();
                loc.setDirection(dir);
                this.mob.setRotation(loc.getYaw(), loc.getPitch());
            }
        }
    }

    private Vector avoidWalls(Vector intendedDir) {
        Vector checkDir;
        Location eyeLoc = this.mob.getEyeLocation();
        if (this.isBlocked(eyeLoc, checkDir = intendedDir.clone().normalize())) {
            double[] angles;
            for (double angle : angles = new double[]{45.0, -45.0, 90.0, -90.0, 135.0, -135.0, 180.0}) {
                Vector rotated = checkDir.clone().rotateAroundY(Math.toRadians(angle));
                if (this.isBlocked(eyeLoc, rotated)) continue;
                return rotated.multiply(0.15);
            }
        }
        return intendedDir;
    }

    private boolean isBlocked(Location origin, Vector direction) {
        return origin.clone().add(direction).getBlock().getType().isSolid();
    }

    private Vector getDirectionToLand() {
        if (this.cooldown-- > 0 && this.cachedLandDirection != null) {
            return this.cachedLandDirection;
        }
        this.cooldown = 20;
        Location start = this.mob.getLocation();
        Block nearestLand = null;
        double nearestDistSq = Double.MAX_VALUE;
        int radius = 8;
        for (int x = -radius; x <= radius; x += 2) {
            for (int z = -radius; z <= radius; z += 2) {
                double distSq;
                Block b = start.getWorld().getBlockAt(start.getBlockX() + x, start.getBlockY(), start.getBlockZ() + z);
                if (!b.getType().isSolid() || b.isLiquid() || !((distSq = b.getLocation().distanceSquared(start)) < nearestDistSq)) continue;
                nearestDistSq = distSq;
                nearestLand = b;
            }
        }
        if (nearestLand != null) {
            this.cachedLandDirection = nearestLand.getLocation().subtract(start).toVector();
            this.cachedLandDirection.setY(0);
            this.cachedLandDirection.normalize().multiply(0.15);
        } else {
            this.cachedLandDirection = start.getDirection().setY(0).normalize().multiply(0.1);
        }
        return this.cachedLandDirection;
    }

    public GoalKey<Creature> getKey() {
        return this.key;
    }

    public EnumSet<GoalType> getTypes() {
        return EnumSet.of(GoalType.JUMP, GoalType.MOVE);
    }
}

