/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.partyanimals;

import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.maboroshi.partyanimals.api.event.PartyAnimalsReloadEvent;
import org.maboroshi.partyanimals.command.PartyAnimalsCommand;
import org.maboroshi.partyanimals.config.ConfigManager;
import org.maboroshi.partyanimals.config.settings.MainConfig;
import org.maboroshi.partyanimals.handler.EffectHandler;
import org.maboroshi.partyanimals.handler.HitCooldownHandler;
import org.maboroshi.partyanimals.handler.RewardHandler;
import org.maboroshi.partyanimals.hook.PartyAnimalsExpansion;
import org.maboroshi.partyanimals.libs.bstats.bukkit.Metrics;
import org.maboroshi.partyanimals.listener.PinataListener;
import org.maboroshi.partyanimals.listener.VoteListener;
import org.maboroshi.partyanimals.manager.BossBarManager;
import org.maboroshi.partyanimals.manager.DatabaseManager;
import org.maboroshi.partyanimals.manager.PinataManager;
import org.maboroshi.partyanimals.util.Logger;
import org.maboroshi.partyanimals.util.MessageUtils;
import org.maboroshi.partyanimals.util.UpdateChecker;
import org.maboroshi.partyanimals.util.VoteReminder;

public final class PartyAnimals
extends JavaPlugin {
    private static PartyAnimals plugin;
    private ConfigManager configManager;
    private Logger log;
    private PinataManager pinataManager;
    private MessageUtils messageUtils;
    private BossBarManager bossBarManager;
    private HitCooldownHandler hitCooldownHandler;
    private EffectHandler effectHandler;
    private RewardHandler rewardHandler;
    private DatabaseManager databaseManager;
    private VoteListener voteListener;
    private ScheduledTask voteReminderTask;

    public void onEnable() {
        plugin = this;
        this.configManager = new ConfigManager(this, this.getDataFolder());
        this.log = new Logger(this);
        try {
            this.configManager.loadConfig();
            this.configManager.loadMessages();
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to load configuration: " + e.getMessage());
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        Metrics metrics = new Metrics((Plugin)this, 28389);
        this.messageUtils = new MessageUtils(this.configManager);
        this.bossBarManager = new BossBarManager(this);
        this.effectHandler = new EffectHandler(this.log);
        this.rewardHandler = new RewardHandler(this);
        this.databaseManager = new DatabaseManager(this);
        this.databaseManager.connect();
        this.setupModules();
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new PartyAnimalsExpansion(this).register();
            this.log.info("Hooked into PlaceholderAPI.");
        }
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> {
            PartyAnimalsCommand partyanimalsCommand = new PartyAnimalsCommand(this);
            ((Commands)event.registrar()).register(partyanimalsCommand.createCommand("partyanimals"), "Main command", List.of("pa"));
        });
        new UpdateChecker(this).checkForUpdates();
    }

    private void setupModules() {
        boolean pinataEnabled = this.configManager.getMainConfig().modules.pinata.enabled;
        if (pinataEnabled) {
            if (this.pinataManager == null) {
                this.pinataManager = new PinataManager(this);
                this.hitCooldownHandler = new HitCooldownHandler(this);
                this.getServer().getPluginManager().registerEvents((Listener)new PinataListener(this), (Plugin)this);
                this.log.info("Pinata module enabled.");
            }
        } else if (this.pinataManager != null) {
            this.pinataManager.cleanup();
            this.pinataManager = null;
            this.hitCooldownHandler = null;
            this.log.info("Pinata module disabled.");
        }
        boolean voteEnabled = this.configManager.getMainConfig().modules.vote.enabled;
        boolean hasNuVotifier = this.getServer().getPluginManager().isPluginEnabled("Votifier");
        if (voteEnabled && hasNuVotifier) {
            if (this.voteListener == null) {
                this.voteListener = new VoteListener(this);
                this.getServer().getPluginManager().registerEvents((Listener)this.voteListener, (Plugin)this);
                this.log.info("Vote module enabled.");
            }
            MainConfig.VoteReminderSettings reminderSettings = this.configManager.getMainConfig().modules.vote.reminder;
            if (reminderSettings.enabled && this.voteReminderTask == null) {
                long intervalTicks = (long)reminderSettings.interval * 20L;
                this.voteReminderTask = Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)this, task -> new VoteReminder(this).run(), intervalTicks, intervalTicks);
            }
        } else {
            if (this.voteReminderTask != null) {
                this.voteReminderTask.cancel();
                this.voteReminderTask = null;
            }
            if (this.voteListener != null) {
                HandlerList.unregisterAll((Listener)this.voteListener);
                this.voteListener = null;
                this.log.info("Vote module disabled.");
            }
            if (voteEnabled && !hasNuVotifier) {
                this.log.warn("Vote module is enabled, but NuVotifier is not installed! Voting features will not work.");
            }
        }
    }

    public boolean reload() {
        try {
            if (this.pinataManager != null) {
                this.pinataManager.cleanup(false);
            }
            if (this.databaseManager != null) {
                this.databaseManager.disconnect();
            }
            this.configManager.loadConfig();
            this.configManager.loadMessages();
            if (this.databaseManager != null) {
                this.databaseManager.connect();
            }
            this.setupModules();
            if (this.pinataManager != null) {
                this.reloadPinatas();
            }
            this.getServer().getPluginManager().callEvent((Event)new PartyAnimalsReloadEvent());
            return true;
        }
        catch (Exception e) {
            this.log.warn("Failed to reload configuration: " + e.getMessage());
            return false;
        }
    }

    private void reloadPinatas() {
        for (World world : Bukkit.getWorlds()) {
            for (LivingEntity entity : world.getLivingEntities()) {
                if (!this.pinataManager.isPinata(entity)) continue;
                this.pinataManager.activatePinata(entity);
            }
        }
        this.log.info("Reloaded pinata entities and tasks.");
    }

    public void onDisable() {
        if (this.pinataManager != null) {
            this.pinataManager.cleanup();
        }
        if (this.bossBarManager != null) {
            this.bossBarManager.removeAll();
        }
        if (this.databaseManager != null) {
            this.databaseManager.disconnect();
        }
    }

    public static PartyAnimals getPlugin() {
        return plugin;
    }

    public Logger getPluginLogger() {
        return this.log;
    }

    public ConfigManager getConfiguration() {
        return this.configManager;
    }

    public PinataManager getPinataManager() {
        return this.pinataManager;
    }

    public MessageUtils getMessageUtils() {
        return this.messageUtils;
    }

    public BossBarManager getBossBarManager() {
        return this.bossBarManager;
    }

    public HitCooldownHandler getHitCooldownHandler() {
        return this.hitCooldownHandler;
    }

    public EffectHandler getEffectHandler() {
        return this.effectHandler;
    }

    public RewardHandler getRewardHandler() {
        return this.rewardHandler;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }
}

