/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.partyanimals.listener;

import com.vexsoftware.votifier.model.Vote;
import com.vexsoftware.votifier.model.VotifierEvent;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.maboroshi.partyanimals.PartyAnimals;
import org.maboroshi.partyanimals.config.ConfigManager;
import org.maboroshi.partyanimals.config.objects.RewardAction;
import org.maboroshi.partyanimals.config.settings.MainConfig;
import org.maboroshi.partyanimals.handler.EffectHandler;
import org.maboroshi.partyanimals.handler.RewardHandler;
import org.maboroshi.partyanimals.manager.DatabaseManager;
import org.maboroshi.partyanimals.util.Logger;

public class VoteListener
implements Listener {
    private final PartyAnimals plugin;
    private final ConfigManager config;
    private final Logger log;
    private final EffectHandler effectHandler;
    private final RewardHandler rewardHandler;
    private final DatabaseManager databaseManager;

    public VoteListener(PartyAnimals plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfiguration();
        this.log = plugin.getPluginLogger();
        this.effectHandler = plugin.getEffectHandler();
        this.rewardHandler = plugin.getRewardHandler();
        this.databaseManager = plugin.getDatabaseManager();
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        if (!this.config.getMainConfig().modules.vote.offline.enabled || !this.config.getMainConfig().modules.vote.offline.queueRewards) {
            return;
        }
        Player player = event.getPlayer();
        Bukkit.getAsyncScheduler().runNow((Plugin)this.plugin, task -> {
            UUID uuid = this.databaseManager.getPlayerUUID(player.getName());
            List<String> commands = this.databaseManager.retrieveRewards(uuid);
            if (!commands.isEmpty()) {
                player.getScheduler().run((Plugin)this.plugin, scheduledTask -> {
                    this.log.info("Delivering " + commands.size() + " offline rewards to " + player.getName());
                    for (String cmd : commands) {
                        String finalCmd = cmd.replace("{player}", player.getName()).replace("{uuid}", player.getUniqueId().toString());
                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)finalCmd);
                    }
                }, null);
            }
        });
    }

    @EventHandler
    public void onVoteEvent(VotifierEvent event) {
        if (!this.config.getMainConfig().modules.vote.enabled) {
            return;
        }
        Vote vote = event.getVote();
        String serviceName = vote.getServiceName();
        String playerName = vote.getUsername();
        String address = vote.getAddress();
        String timeStamp = vote.getTimeStamp();
        Bukkit.getAsyncScheduler().runNow((Plugin)this.plugin, task -> {
            this.log.debug("Received vote from " + playerName + " via " + serviceName + " at " + timeStamp + " (IP: " + address + ")");
            UUID uuid = this.databaseManager.getPlayerUUID(playerName);
            if (!serviceName.equals("TestVote (Dry Run)")) {
                int required;
                int currentTotal;
                this.databaseManager.addVote(uuid, playerName, serviceName, 1);
                MainConfig.CommunityGoalSettings goalConfig = this.config.getMainConfig().modules.vote.communityGoal;
                if (goalConfig.enabled && goalConfig.votesRequired > 0 && (currentTotal = this.databaseManager.incrementCommunityGoalProgress()) % (required = goalConfig.votesRequired) == 0) {
                    this.log.info("Community Goal reached (Total Votes: " + currentTotal + ")! Firing rewards...");
                    Bukkit.getGlobalRegionScheduler().execute((Plugin)this.plugin, () -> this.rewardHandler.process(null, goalConfig.rewards.values()));
                }
            }
            UUID finalUUID = uuid;
            Bukkit.getGlobalRegionScheduler().execute((Plugin)this.plugin, () -> {
                Player player = Bukkit.getPlayer((String)playerName);
                if (player != null) {
                    player.getScheduler().run((Plugin)this.plugin, st -> {
                        MainConfig.VoteEvent voteEvent = this.config.getMainConfig().modules.vote.events.vote;
                        if (!voteEvent.enabled) {
                            return;
                        }
                        this.effectHandler.playEffects(voteEvent.effects, player.getLocation(), false);
                        this.rewardHandler.process((OfflinePlayer)player, voteEvent.rewards.values());
                    }, null);
                } else {
                    MainConfig.OfflineVoteSettings offlineSettings = this.config.getMainConfig().modules.vote.offline;
                    if (offlineSettings.enabled) {
                        MainConfig.VoteEvent voteEvent = this.config.getMainConfig().modules.vote.events.vote;
                        if (offlineSettings.queueRewards) {
                            Bukkit.getAsyncScheduler().runNow((Plugin)this.plugin, at -> {
                                for (RewardAction action : voteEvent.rewards.values()) {
                                    if (!this.shouldRun(action)) continue;
                                    this.processActionForQueue(finalUUID, playerName, action);
                                    if (!action.preventFurtherRewards) continue;
                                    break;
                                }
                            });
                        } else {
                            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)finalUUID);
                            this.rewardHandler.process(offlinePlayer, voteEvent.rewards.values());
                            this.log.debug("Processed immediate offline rewards for " + playerName);
                        }
                    }
                }
            });
        });
    }

    private boolean shouldRun(RewardAction action) {
        if (action.chance >= 100.0) {
            return true;
        }
        return ThreadLocalRandom.current().nextDouble(100.0) <= action.chance;
    }

    private void processActionForQueue(UUID uuid, String playerName, RewardAction action) {
        if (action.commands.isEmpty()) {
            return;
        }
        if (action.pickOneRandom) {
            int index = ThreadLocalRandom.current().nextInt(action.commands.size());
            String cmd = action.commands.get(index);
            this.databaseManager.queueRewards(uuid, cmd);
        } else {
            for (String cmd : action.commands) {
                this.databaseManager.queueRewards(uuid, cmd);
            }
        }
        this.log.debug("Queued offline rewards for " + playerName);
    }
}

