/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.partyanimals.hook;

import java.util.Calendar;
import java.util.UUID;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.maboroshi.partyanimals.PartyAnimals;
import org.maboroshi.partyanimals.config.settings.MainConfig;
import org.maboroshi.partyanimals.manager.PinataManager;

public class PartyAnimalsExpansion
extends PlaceholderExpansion {
    private final PartyAnimals plugin;

    public PartyAnimalsExpansion(PartyAnimals plugin) {
        this.plugin = plugin;
    }

    public String getIdentifier() {
        return "partyanimals";
    }

    public String getAuthor() {
        return this.plugin.getPluginMeta().getAuthors().toString();
    }

    public String getVersion() {
        return this.plugin.getPluginMeta().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public String onPlaceholderRequest(Player player, @NotNull String params) {
        PinataManager pinataManager = this.plugin.getPinataManager();
        if (pinataManager != null && params.startsWith("pinata_")) {
            if (params.equals("pinata_count")) {
                return String.valueOf(pinataManager.getActivePinataCount());
            }
            if (params.equals("pinata_any_alive")) {
                return String.valueOf(pinataManager.isPinataAlive());
            }
            if (params.startsWith("pinata_nearest_")) {
                if (player == null) {
                    return "";
                }
                LivingEntity pinata = pinataManager.getNearestPinata(player.getLocation());
                String subParam = params.substring("pinata_nearest_".length());
                if (pinata == null) {
                    return switch (subParam) {
                        case "health", "max_health" -> "0";
                        case "alive" -> "false";
                        case "location" -> "N/A";
                        default -> null;
                    };
                }
                return switch (subParam) {
                    case "alive" -> "true";
                    case "health" -> String.valueOf(pinataManager.getPinataHealth(pinata));
                    case "max_health" -> String.valueOf(pinataManager.getPinataMaxHealth(pinata));
                    case "location" -> {
                        Location loc = pinata.getLocation();
                        yield loc.getWorld().getName() + ", " + loc.getBlockX() + ", " + loc.getBlockY() + ", " + loc.getBlockZ();
                    }
                    default -> null;
                };
            }
        }
        if (player != null) {
            if (params.equals("votes")) {
                UUID targetUUID = this.plugin.getDatabaseManager().getPlayerUUID(player.getName());
                return String.valueOf(this.plugin.getDatabaseManager().getVotes(targetUUID));
            }
            if (params.startsWith("votes_")) {
                String period = params.substring("votes_".length()).toLowerCase();
                UUID targetUUID = this.plugin.getDatabaseManager().getPlayerUUID(player.getName());
                long startTimestamp = 0L;
                Calendar cal = Calendar.getInstance();
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                switch (period) {
                    case "daily": {
                        startTimestamp = cal.getTimeInMillis();
                        break;
                    }
                    case "weekly": {
                        cal.set(7, cal.getFirstDayOfWeek());
                        startTimestamp = cal.getTimeInMillis();
                        break;
                    }
                    case "monthly": {
                        cal.set(5, 1);
                        startTimestamp = cal.getTimeInMillis();
                        break;
                    }
                    case "yearly": {
                        cal.set(6, 1);
                        startTimestamp = cal.getTimeInMillis();
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                return String.valueOf(this.plugin.getDatabaseManager().getVotesSince(targetUUID, startTimestamp));
            }
            if (params.startsWith("votes_previous_")) {
                String period = params.substring("votes_previous_".length()).toLowerCase();
                UUID targetUUID = this.plugin.getDatabaseManager().getPlayerUUID(player.getName());
                Calendar cal = Calendar.getInstance();
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                long endTimestamp = 0L;
                long startTimestamp = 0L;
                switch (period) {
                    case "daily": {
                        endTimestamp = cal.getTimeInMillis();
                        cal.add(5, -1);
                        startTimestamp = cal.getTimeInMillis();
                        break;
                    }
                    case "weekly": {
                        cal.set(7, cal.getFirstDayOfWeek());
                        endTimestamp = cal.getTimeInMillis();
                        cal.add(3, -1);
                        startTimestamp = cal.getTimeInMillis();
                        break;
                    }
                    case "monthly": {
                        cal.set(5, 1);
                        endTimestamp = cal.getTimeInMillis();
                        cal.add(2, -1);
                        startTimestamp = cal.getTimeInMillis();
                        break;
                    }
                    case "yearly": {
                        cal.set(6, 1);
                        endTimestamp = cal.getTimeInMillis();
                        cal.add(1, -1);
                        startTimestamp = cal.getTimeInMillis();
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                return String.valueOf(this.plugin.getDatabaseManager().getVotesBetween(targetUUID, startTimestamp, endTimestamp));
            }
        }
        if (params.startsWith("vote_community_")) {
            int visualProgress;
            MainConfig.CommunityGoalSettings goalConfig = this.plugin.getConfiguration().getMainConfig().modules.vote.communityGoal;
            if (!goalConfig.enabled) {
                return "Disabled";
            }
            int rawTotal = this.plugin.getDatabaseManager().getCommunityGoalProgress();
            int required = goalConfig.votesRequired;
            int n = visualProgress = required > 0 ? rawTotal % required : 0;
            if (visualProgress == 0 && rawTotal > 0) {
                visualProgress = required;
            }
            return switch (params) {
                case "vote_community_current" -> String.valueOf(visualProgress);
                case "vote_community_required" -> String.valueOf(required);
                case "vote_community_percentage" -> {
                    if (required == 0) {
                        yield "0%";
                    }
                    int percent = (int)((double)visualProgress / (double)required * 100.0);
                    yield percent + "%";
                }
                case "vote_community_total" -> String.valueOf(rawTotal);
                case "vote_community_remaining" -> {
                    int remaining = required - visualProgress;
                    if (remaining == 0) {
                        remaining = required;
                    }
                    yield String.valueOf(remaining);
                }
                case "vote_community_goals_met" -> String.valueOf(required > 0 ? rawTotal / required : 0);
                default -> null;
            };
        }
        return null;
    }
}

