/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.partyanimals.manager;

import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.maboroshi.partyanimals.PartyAnimals;
import org.maboroshi.partyanimals.manager.DatabaseManager;

public class LeaderboardManager {
    private final PartyAnimals plugin;
    private final DatabaseManager db;
    private final ConcurrentHashMap<String, List<DatabaseManager.TopVoter>> cache = new ConcurrentHashMap();

    public LeaderboardManager(PartyAnimals plugin) {
        this.plugin = plugin;
        this.db = plugin.getDatabaseManager();
        this.startUpdateTask();
    }

    private void startUpdateTask() {
        Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)this.plugin, task -> this.refreshLeaderboards(), 0L, 300L, TimeUnit.SECONDS);
    }

    public void refreshLeaderboards() {
        long now = System.currentTimeMillis();
        this.cache.put("alltime", this.db.getTopVoters(0L, 10));
        this.cache.put("last_24h", this.db.getTopVoters(now - 86400000L, 10));
        this.cache.put("last_7d", this.db.getTopVoters(now - 604800000L, 10));
        this.cache.put("last_30d", this.db.getTopVoters(now - 2592000000L, 10));
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.cache.put("daily", this.db.getTopVoters(cal.getTimeInMillis(), 10));
        Calendar weekCal = (Calendar)cal.clone();
        weekCal.set(7, weekCal.getFirstDayOfWeek());
        this.cache.put("weekly", this.db.getTopVoters(weekCal.getTimeInMillis(), 10));
        Calendar monthCal = (Calendar)cal.clone();
        monthCal.set(5, 1);
        this.cache.put("monthly", this.db.getTopVoters(monthCal.getTimeInMillis(), 10));
        Calendar yearCal = (Calendar)cal.clone();
        yearCal.set(6, 1);
        this.cache.put("yearly", this.db.getTopVoters(yearCal.getTimeInMillis(), 10));
    }

    public DatabaseManager.TopVoter getTopVoter(String type, int rank) {
        List list = this.cache.getOrDefault(type.toLowerCase(), Collections.emptyList());
        int index = rank - 1;
        if (index >= 0 && index < list.size()) {
            return (DatabaseManager.TopVoter)list.get(index);
        }
        return new DatabaseManager.TopVoter("---", 0);
    }
}

