/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.partyanimals.hook;

import java.util.UUID;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.maboroshi.partyanimals.PartyAnimals;
import org.maboroshi.partyanimals.config.settings.MainConfig;
import org.maboroshi.partyanimals.manager.DatabaseManager;
import org.maboroshi.partyanimals.manager.PinataManager;

public class PartyAnimalsExpansion
extends PlaceholderExpansion {
    private final PartyAnimals plugin;

    public PartyAnimalsExpansion(PartyAnimals plugin) {
        this.plugin = plugin;
    }

    public String getIdentifier() {
        return "partyanimals";
    }

    public String getAuthor() {
        return this.plugin.getPluginMeta().getAuthors().toString();
    }

    public String getVersion() {
        return this.plugin.getPluginMeta().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public String onPlaceholderRequest(Player player, @NotNull String params) {
        PinataManager pinataManager = this.plugin.getPinataManager();
        if (pinataManager != null && params.startsWith("pinata_")) {
            if (params.equals("pinata_count")) {
                return String.valueOf(pinataManager.getActivePinataCount());
            }
            if (params.equals("pinata_any_alive")) {
                return String.valueOf(pinataManager.isPinataAlive());
            }
            if (params.startsWith("pinata_nearest_")) {
                if (player == null) {
                    return "";
                }
                LivingEntity pinata = pinataManager.getNearestPinata(player.getLocation());
                String subParam = params.substring("pinata_nearest_".length());
                if (pinata == null) {
                    return switch (subParam) {
                        case "health", "max_health" -> "0";
                        case "alive" -> "false";
                        case "location" -> "N/A";
                        default -> null;
                    };
                }
                return switch (subParam) {
                    case "alive" -> "true";
                    case "health" -> String.valueOf(pinataManager.getPinataHealth(pinata));
                    case "max_health" -> String.valueOf(pinataManager.getPinataMaxHealth(pinata));
                    case "location" -> {
                        Location loc = pinata.getLocation();
                        yield loc.getWorld().getName() + ", " + loc.getBlockX() + ", " + loc.getBlockY() + ", " + loc.getBlockZ();
                    }
                    default -> null;
                };
            }
        }
        if (this.plugin.getLeaderboardManager() != null && params.startsWith("top_")) {
            return this.handleLeaderboardPlaceholders(params);
        }
        if (player != null && params.equals("votes")) {
            UUID targetUUID = this.plugin.getDatabaseManager().getPlayerUUID(player.getName());
            return String.valueOf(this.plugin.getDatabaseManager().getVotes(targetUUID));
        }
        if (params.startsWith("vote_community_")) {
            int visualProgress;
            MainConfig.CommunityGoalSettings goalConfig = this.plugin.getConfiguration().getMainConfig().modules.vote.communityGoal;
            if (!goalConfig.enabled) {
                return "Disabled";
            }
            int rawTotal = this.plugin.getDatabaseManager().getCommunityGoalProgress();
            int required = goalConfig.votesRequired;
            int n = visualProgress = required > 0 ? rawTotal % required : 0;
            if (visualProgress == 0 && rawTotal > 0) {
                visualProgress = required;
            }
            return switch (params) {
                case "vote_community_current" -> String.valueOf(visualProgress);
                case "vote_community_required" -> String.valueOf(required);
                case "vote_community_percentage" -> {
                    if (required == 0) {
                        yield "0%";
                    }
                    int percent = (int)((double)visualProgress / (double)required * 100.0);
                    yield percent + "%";
                }
                case "vote_community_total" -> String.valueOf(rawTotal);
                case "vote_community_remaining" -> {
                    int remaining = required - visualProgress;
                    if (remaining == 0) {
                        remaining = required;
                    }
                    yield String.valueOf(remaining);
                }
                case "vote_community_goals_met" -> String.valueOf(required > 0 ? rawTotal / required : 0);
                default -> null;
            };
        }
        return null;
    }

    private String handleLeaderboardPlaceholders(String params) {
        int rank;
        String[] parts = params.split("_");
        if (parts.length < 4) {
            return null;
        }
        String field = parts[parts.length - 1];
        String rankStr = parts[parts.length - 2];
        try {
            rank = Integer.parseInt(rankStr);
        }
        catch (NumberFormatException e) {
            return null;
        }
        StringBuilder typeBuilder = new StringBuilder();
        for (int i = 1; i < parts.length - 2; ++i) {
            if (i > 1) {
                typeBuilder.append("_");
            }
            typeBuilder.append(parts[i]);
        }
        String type = typeBuilder.toString();
        DatabaseManager.TopVoter top = this.plugin.getLeaderboardManager().getTopVoter(type, rank);
        if (field.equalsIgnoreCase("name")) {
            return top.name();
        }
        if (field.equalsIgnoreCase("votes")) {
            return String.valueOf(top.votes());
        }
        return null;
    }
}

