/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.partyanimals.handler;

import java.util.Collection;
import java.util.concurrent.ThreadLocalRandom;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.maboroshi.partyanimals.PartyAnimals;
import org.maboroshi.partyanimals.config.objects.RewardAction;

public class RewardHandler {
    private final boolean hasPAPI = Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI");

    public RewardHandler(PartyAnimals plugin) {
    }

    public void process(OfflinePlayer player, Collection<RewardAction> commands) {
        if (commands == null || commands.isEmpty()) {
            return;
        }
        for (RewardAction action : commands) {
            double roll;
            Player onlinePlayer;
            if (!action.global && action.permission != null && !action.permission.isEmpty() && (onlinePlayer = player.getPlayer()) != null && !onlinePlayer.hasPermission(action.permission) || action.chance < 100.0 && (roll = ThreadLocalRandom.current().nextDouble(100.0)) > action.chance) continue;
            if (action.global) {
                for (Player onlinePlayer2 : Bukkit.getOnlinePlayers()) {
                    this.executeAction((OfflinePlayer)onlinePlayer2, action);
                }
            } else {
                this.executeAction(player, action);
            }
            if (!action.preventFurtherRewards) continue;
            break;
        }
    }

    private void executeAction(OfflinePlayer target, RewardAction action) {
        if (action.commands.isEmpty()) {
            return;
        }
        if (action.pickOneRandom) {
            int index = ThreadLocalRandom.current().nextInt(action.commands.size());
            String randomCmd = action.commands.get(index);
            this.dispatch(target, randomCmd);
        } else {
            for (String cmd : action.commands) {
                this.dispatch(target, cmd);
            }
        }
    }

    private void dispatch(OfflinePlayer player, String command) {
        if (command == null || command.isEmpty()) {
            return;
        }
        String parsed = command;
        if (player != null) {
            String name = player.getName();
            parsed = parsed.replace("{player}", name != null ? name : "Unknown").replace("{uuid}", player.getUniqueId().toString());
        }
        if (player != null && this.hasPAPI) {
            parsed = PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)parsed);
        }
        if (parsed.startsWith("/")) {
            parsed = parsed.substring(1);
        }
        String finalCommand = parsed;
        Bukkit.getGlobalRegionScheduler().execute((Plugin)PartyAnimals.getPlugin(), () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)finalCommand));
    }
}

