/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.partyanimals.config;

import de.exlll.configlib.ConfigLib;
import de.exlll.configlib.YamlConfigurationProperties;
import de.exlll.configlib.YamlConfigurations;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.maboroshi.partyanimals.PartyAnimals;
import org.maboroshi.partyanimals.config.settings.MainConfig;
import org.maboroshi.partyanimals.config.settings.MessageConfig;
import org.maboroshi.partyanimals.config.settings.PinataConfig;

public class ConfigManager {
    private final File dataFolder;
    private final PartyAnimals plugin;
    private MainConfig.MainConfiguration mainConfig;
    private Map<String, PinataConfig.PinataConfiguration> pinataConfigs;
    private MessageConfig.MessageConfiguration messageConfig;

    public ConfigManager(PartyAnimals plugin, File dataFolder) {
        this.dataFolder = dataFolder;
        this.plugin = plugin;
        this.pinataConfigs = new HashMap<String, PinataConfig.PinataConfiguration>();
    }

    public void loadConfig() {
        this.mainConfig = MainConfig.load(this.dataFolder);
        this.loadPinataConfigs();
    }

    private void loadPinataConfigs() {
        File[] files;
        File defaultPinata;
        this.pinataConfigs.clear();
        File pinataFolder = new File(this.dataFolder, "pinatas");
        if (!pinataFolder.exists()) {
            pinataFolder.mkdirs();
        }
        if (!(defaultPinata = new File(pinataFolder, "default.yml")).exists()) {
            PinataConfig.load(defaultPinata);
        }
        if ((files = pinataFolder.listFiles((dir, name) -> name.endsWith(".yml"))) != null) {
            for (File file : files) {
                String fileName = file.getName();
                if (fileName.contains(" ")) {
                    this.plugin.getLogger().warning("Pinata config file '" + fileName + "' contains spaces in its name and will be skipped.");
                    continue;
                }
                String id = fileName.substring(0, fileName.lastIndexOf(46));
                PinataConfig.PinataConfiguration config = PinataConfig.load(file);
                this.pinataConfigs.put(id, config);
            }
        }
    }

    public void loadMessages() {
        this.messageConfig = MessageConfig.load(this.dataFolder);
    }

    public void saveConfig() {
        Path settingsPath = new File(this.dataFolder, "config.yml").toPath();
        YamlConfigurations.save((Path)settingsPath, MainConfig.MainConfiguration.class, (Object)this.mainConfig, (YamlConfigurationProperties)ConfigLib.BUKKIT_DEFAULT_PROPERTIES);
        for (Map.Entry<String, PinataConfig.PinataConfiguration> entry : this.pinataConfigs.entrySet()) {
            Path path = new File(this.dataFolder, "pinatas/" + entry.getKey() + ".yml").toPath();
            YamlConfigurations.save((Path)path, PinataConfig.PinataConfiguration.class, (Object)entry.getValue(), (YamlConfigurationProperties)ConfigLib.BUKKIT_DEFAULT_PROPERTIES);
        }
    }

    public void saveMessages() {
        Path path = new File(this.dataFolder, "messages.yml").toPath();
        YamlConfigurations.save((Path)path, MessageConfig.MessageConfiguration.class, (Object)this.messageConfig, (YamlConfigurationProperties)ConfigLib.BUKKIT_DEFAULT_PROPERTIES);
    }

    public MainConfig.MainConfiguration getMainConfig() {
        return this.mainConfig;
    }

    public PinataConfig.PinataConfiguration getPinataConfig(String id) {
        return this.pinataConfigs.get(id);
    }

    public Map<String, PinataConfig.PinataConfiguration> getPinataConfigs() {
        return this.pinataConfigs;
    }

    public MessageConfig.MessageConfiguration getMessageConfig() {
        return this.messageConfig;
    }
}

