/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.ordinal.manager;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.maboroshi.ordinal.Ordinal;
import org.maboroshi.ordinal.config.ConfigManager;
import org.maboroshi.ordinal.util.Logger;

public class OrdinalManager {
    private final Ordinal plugin;
    private final ConfigManager config;
    private final Logger log;
    private final NamespacedKey ordinal_rank;
    private final ConcurrentHashMap<UUID, Integer> legacyCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Integer> legacyNameCache = new ConcurrentHashMap();

    public OrdinalManager(Ordinal plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfigManager();
        this.log = plugin.getPluginLogger();
        this.ordinal_rank = new NamespacedKey((Plugin)plugin, "ordinal_rank");
        this.loadExistingPlayers();
    }

    public int getOrdinal(Player player) {
        if (!player.getPersistentDataContainer().has(this.ordinal_rank, PersistentDataType.INTEGER)) {
            this.log.debug("Player " + player.getName() + " does not have an ordinal rank assigned");
            return -1;
        }
        int ordinal = (Integer)player.getPersistentDataContainer().get(this.ordinal_rank, PersistentDataType.INTEGER);
        return ordinal;
    }

    public void assignOrdinal(Player player) {
        int nextOrdinal = this.config.ordinalData.nextOrdinal;
        player.getPersistentDataContainer().set(this.ordinal_rank, PersistentDataType.INTEGER, (Object)nextOrdinal);
        this.config.updateNextOrdinal(nextOrdinal + 1);
        this.log.debug("Assigned Ordinal Rank #" + nextOrdinal + " to " + player.getName());
    }

    public void assignOrdinal(Player player, int providedOrdinal) {
        player.getPersistentDataContainer().set(this.ordinal_rank, PersistentDataType.INTEGER, (Object)providedOrdinal);
        this.log.debug("Migrated " + player.getName() + " to Legacy Ordinal #" + providedOrdinal);
    }

    public NamespacedKey getOrdinalRankKey() {
        return this.ordinal_rank;
    }

    private void loadExistingPlayers() {
        this.log.debug("Calculating join order for existing players...");
        Bukkit.getAsyncScheduler().runNow((Plugin)this.plugin, task -> {
            long start = System.currentTimeMillis();
            List<OfflinePlayer> allPlayers = Arrays.asList(Bukkit.getOfflinePlayers());
            this.log.debug("Found " + allPlayers.size() + " offline players to process");
            allPlayers.sort(Comparator.comparingLong(OfflinePlayer::getFirstPlayed));
            HashMap<UUID, Integer> tempLegacyCache = new HashMap<UUID, Integer>();
            HashMap<String, Integer> tempLegacyNameCache = new HashMap<String, Integer>();
            int index = 1;
            for (OfflinePlayer p : allPlayers) {
                tempLegacyCache.put(p.getUniqueId(), index++);
                if (p.getName() == null) continue;
                tempLegacyNameCache.put(p.getName().toLowerCase(), index - 1);
            }
            int finalNextOrdinal = index;
            long time = System.currentTimeMillis() - start;
            Bukkit.getGlobalRegionScheduler().run((Plugin)this.plugin, scheduledTask -> {
                this.legacyCache.putAll(tempLegacyCache);
                this.legacyNameCache.putAll(tempLegacyNameCache);
                if (this.config.ordinalData.nextOrdinal < finalNextOrdinal) {
                    this.log.debug("Updating nextOrdinal from " + this.config.ordinalData.nextOrdinal + " to " + finalNextOrdinal);
                    this.config.updateNextOrdinal(finalNextOrdinal);
                } else {
                    this.log.debug("nextOrdinal already at " + this.config.ordinalData.nextOrdinal + ", no update needed");
                }
                this.log.debug("Calculation complete. Loaded " + (finalNextOrdinal - 1) + " players in " + time + "ms.");
            });
        });
    }

    public int checkExistingOrdinal(Player player) {
        this.log.debug("Checking existing ordinal for " + player.getName() + " (UUID: " + String.valueOf(player.getUniqueId()) + ")");
        if (this.legacyCache.containsKey(player.getUniqueId())) {
            int ordinal = this.legacyCache.get(player.getUniqueId());
            this.log.debug("Found ordinal #" + ordinal + " in UUID cache");
            return ordinal;
        }
        int ordinal = this.legacyNameCache.getOrDefault(player.getName().toLowerCase(), -1);
        this.log.debug("Found ordinal #" + ordinal + " in name cache (or -1 if not found)");
        return ordinal;
    }

    public void resetAndRecalculate(Player player) {
        if (player.getPersistentDataContainer().has(this.ordinal_rank, PersistentDataType.INTEGER)) {
            player.getPersistentDataContainer().remove(this.ordinal_rank);
        }
        int legacyOrdinal = this.checkExistingOrdinal(player);
        this.log.debug("Resetting and recalculating ordinal for " + player.getName() + ". Legacy ordinal: " + legacyOrdinal);
        if (legacyOrdinal > 0) {
            this.assignOrdinal(player, legacyOrdinal);
        } else {
            this.assignOrdinal(player);
        }
    }
}

