/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.ordinal.config;

import de.exlll.configlib.ConfigLib;
import de.exlll.configlib.NameFormatter;
import de.exlll.configlib.NameFormatters;
import de.exlll.configlib.YamlConfigurationProperties;
import de.exlll.configlib.YamlConfigurations;
import java.io.File;
import java.nio.file.Path;
import org.maboroshi.ordinal.config.data.OrdinalData;
import org.maboroshi.ordinal.config.settings.MainConfig;
import org.maboroshi.ordinal.config.settings.MessageConfig;

public class ConfigManager {
    private final File dataFolder;
    private MainConfig.MainConfiguration mainConfig;
    private MessageConfig.MessageConfiguration messageConfig;
    public OrdinalData ordinalData;
    private Path dataPath;

    public ConfigManager(File dataFolder) {
        this.dataFolder = dataFolder;
    }

    public void load() {
        this.mainConfig = MainConfig.load(this.dataFolder);
        this.messageConfig = MessageConfig.load(this.dataFolder);
        YamlConfigurationProperties properties = ((YamlConfigurationProperties.Builder)ConfigLib.BUKKIT_DEFAULT_PROPERTIES.toBuilder().setNameFormatter((NameFormatter)NameFormatters.LOWER_KEBAB_CASE)).build();
        this.dataPath = new File(this.dataFolder, "data.yml").toPath();
        this.ordinalData = (OrdinalData)YamlConfigurations.update((Path)this.dataPath, OrdinalData.class, (YamlConfigurationProperties)properties);
    }

    public void updateNextOrdinal(int newValue) {
        this.ordinalData.nextOrdinal = newValue;
        this.saveData();
    }

    private void saveData() {
        YamlConfigurations.save((Path)this.dataPath, OrdinalData.class, (Object)this.ordinalData);
    }

    public MainConfig.MainConfiguration getMainConfig() {
        return this.mainConfig;
    }

    public MessageConfig.MessageConfiguration getMessageConfig() {
        return this.messageConfig;
    }

    public OrdinalData getOrdinalData() {
        return this.ordinalData;
    }
}

