/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.ordinal.listener;

import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.maboroshi.ordinal.Ordinal;
import org.maboroshi.ordinal.manager.OrdinalManager;

public class JoinListener
implements Listener {
    private final Ordinal plugin;
    private final OrdinalManager ordinalManager;

    public JoinListener(Ordinal plugin) {
        this.plugin = plugin;
        this.ordinalManager = plugin.getOrdinalManager();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this.plugin.getConfigManager().getMainConfig().seniority.enabled) {
            return;
        }
        int currentOrdinal = this.ordinalManager.getOrdinal(event.getPlayer());
        int legacyOrdinal = this.ordinalManager.checkExistingOrdinal(event.getPlayer());
        if (currentOrdinal == -1) {
            if (legacyOrdinal > 0) {
                this.plugin.getLogger().info("Player " + event.getPlayer().getName() + " is a legacy player. Migrating to ordinal #" + legacyOrdinal);
                this.ordinalManager.assignOrdinal(event.getPlayer(), legacyOrdinal);
            } else {
                this.plugin.getLogger().info("Player " + event.getPlayer().getName() + " is a new joiner. Assigning new ordinal.");
                this.ordinalManager.assignOrdinal(event.getPlayer());
            }
        } else {
            this.plugin.getLogger().info("Player " + event.getPlayer().getName() + " has rejoined with ordinal: " + currentOrdinal);
        }
    }
}

