/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.ordinal.config.settings;

import de.exlll.configlib.Comment;
import de.exlll.configlib.ConfigLib;
import de.exlll.configlib.Configuration;
import de.exlll.configlib.NameFormatter;
import de.exlll.configlib.NameFormatters;
import de.exlll.configlib.YamlConfigurationProperties;
import de.exlll.configlib.YamlConfigurations;
import java.io.File;
import java.nio.file.Path;

public final class MessageConfig {
    public static MessageConfiguration load(File dataFolder) {
        YamlConfigurationProperties properties = ((YamlConfigurationProperties.Builder)ConfigLib.BUKKIT_DEFAULT_PROPERTIES.toBuilder().setNameFormatter((NameFormatter)NameFormatters.LOWER_KEBAB_CASE)).build();
        Path configFile = new File(dataFolder, "messages.yml").toPath();
        return (MessageConfiguration)YamlConfigurations.update((Path)configFile, MessageConfiguration.class, (YamlConfigurationProperties)properties);
    }

    @Configuration
    public static class MessageConfiguration {
        @Comment(value={"Settings related to messages sent by the plugin."})
        public MessageSettings messages = new MessageSettings();
    }

    @Configuration
    public static class MessageSettings {
        @Comment(value={"Prefix for all messages sent by the plugin."})
        public String prefix = "<color:#74c7ec><bold>Ordinal</bold></color> <dark_gray>\u279f</dark_gray>";
        @Comment(value={"Message displayed when the plugin is reloaded."})
        public String reloadSuccess = "<prefix> <green>Plugin configuration has been reloaded successfully.</green>";
        @Comment(value={"Message displayed when the plugin fails to reload."})
        public String reloadFail = "<prefix> <red>Failed to reload plugin configuration! Check console for errors.</red>";
        @Comment(value={"Message displayed when a new version of the plugin is available."})
        public String updateAvailable = "<prefix> A new version is available! <gray>(Current: <red><current_version></red> | Latest: <green><latest_version></green>)</gray>";
        @Comment(value={"Message shown when using /ordinal command without arguments."})
        public String helpInfo = "<green>\ud83d\udec8</green> <gray>Type <white>/ordinal reload</white> to reload the configuration.</gray>";
        @Comment(value={"Message shown when a player is not found for the reset command."})
        public String playerNotFound = "<prefix> <red>Player not found.</red>";
        @Comment(value={"Message shown when a player's ordinal is successfully reset."})
        public String resetSuccess = "<prefix> <green>Reset complete for <white><player></white>. New Rank: <yellow><rank></yellow></green>";

        public MessageSettings() {
        }

        public MessageSettings(String prefix, String reloadSuccess, String reloadFail, String updateAvailable) {
            this.prefix = prefix;
            this.reloadSuccess = reloadSuccess;
            this.reloadFail = reloadFail;
            this.updateAvailable = updateAvailable;
        }
    }
}

