/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.ordinal.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.maboroshi.ordinal.Ordinal;
import org.maboroshi.ordinal.config.ConfigManager;
import org.maboroshi.ordinal.util.Logger;
import org.maboroshi.ordinal.util.MessageUtils;

public class OrdinalCommand {
    private final Ordinal plugin;
    private final Logger log;
    private final MessageUtils messageUtils;

    public OrdinalCommand(Ordinal plugin) {
        this.plugin = plugin;
        this.log = plugin.getPluginLogger();
        this.messageUtils = plugin.getMessageUtils();
    }

    public LiteralCommandNode<CommandSourceStack> createCommand(String commandName) {
        ConfigManager config = this.plugin.getConfigManager();
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandName).executes(ctx -> {
            CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
            this.messageUtils.send((Audience)sender, "<prefix>Plugin version: <green><version></green>", this.messageUtils.tag("version", this.plugin.getPluginMeta().getVersion()));
            this.messageUtils.send((Audience)sender, config.getMessageConfig().messages.helpInfo, new TagResolver[0]);
            return 1;
        })).then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(sender -> sender.getSender().hasPermission("ordinal.reload"))).executes(ctx -> {
            CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
            if (this.plugin.reload()) {
                this.log.info("Configuration reloaded by " + sender.getName());
                this.messageUtils.send((Audience)sender, config.getMessageConfig().messages.reloadSuccess, new TagResolver[0]);
            } else {
                this.log.warn("Failed to reload configuration by " + sender.getName());
                this.messageUtils.send((Audience)sender, config.getMessageConfig().messages.reloadFail, new TagResolver[0]);
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"reset").requires(ctx -> ctx.getSender().hasPermission("ordinal.admin"))).then(Commands.argument((String)"target", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            for (Player p : Bukkit.getOnlinePlayers()) {
                builder.suggest(p.getName());
            }
            return builder.buildFuture();
        }).executes(ctx -> {
            CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
            String targetName = (String)ctx.getArgument("target", String.class);
            Player target = Bukkit.getPlayer((String)targetName);
            if (target == null) {
                this.messageUtils.send((Audience)sender, config.getMessageConfig().messages.playerNotFound, new TagResolver[0]);
                return 0;
            }
            this.plugin.getOrdinalManager().resetAndRecalculate(target);
            int newRank = this.plugin.getOrdinalManager().getOrdinal(target);
            this.messageUtils.send((Audience)sender, config.getMessageConfig().messages.resetSuccess, this.messageUtils.tagParsed("player", target.getName()), this.messageUtils.tag("rank", newRank));
            return 1;
        })))).build();
    }
}

