/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.ordinal;

import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.maboroshi.ordinal.command.OrdinalCommand;
import org.maboroshi.ordinal.config.ConfigManager;
import org.maboroshi.ordinal.hook.OrdinalExpansion;
import org.maboroshi.ordinal.libs.bstats.bukkit.Metrics;
import org.maboroshi.ordinal.listener.JoinListener;
import org.maboroshi.ordinal.manager.OrdinalManager;
import org.maboroshi.ordinal.util.Logger;
import org.maboroshi.ordinal.util.MessageUtils;
import org.maboroshi.ordinal.util.UpdateChecker;

public final class Ordinal
extends JavaPlugin {
    private static Ordinal plugin;
    private Logger log;
    private ConfigManager configManager;
    private MessageUtils messageUtils;
    private OrdinalManager ordinalManager;

    public void onEnable() {
        plugin = this;
        this.log = new Logger(this);
        if (!this.reload()) {
            this.log.error("Disabling plugin due to critical configuration error.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.ordinalManager = new OrdinalManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)new JoinListener(this), (Plugin)this);
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new OrdinalExpansion(this).register();
            this.getLogger().info("PlaceholderAPI hook enabled.");
        }
        Metrics metrics = new Metrics((Plugin)this, 28615);
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> {
            OrdinalCommand ordinalCommand = new OrdinalCommand(this);
            ((Commands)event.registrar()).register(ordinalCommand.createCommand("ordinal"), "Main command");
        });
        new UpdateChecker(this).checkForUpdates();
    }

    public boolean reload() {
        try {
            if (this.configManager == null) {
                this.configManager = new ConfigManager(this.getDataFolder());
            }
            this.configManager.load();
            if (this.messageUtils == null) {
                this.messageUtils = new MessageUtils(this.configManager);
            }
            return true;
        }
        catch (Exception e) {
            this.log.error("Failed to load configuration: " + e.getMessage());
            return false;
        }
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public OrdinalManager getOrdinalManager() {
        return this.ordinalManager;
    }

    public MessageUtils getMessageUtils() {
        return this.messageUtils;
    }

    public Logger getPluginLogger() {
        return this.log;
    }
}

