/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.junction.permission;

import net.milkbowl.vault2.permission.Permission;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.maboroshi.junction.Junction;
import org.maboroshi.junction.permission.PermissionProvider;
import org.maboroshi.junction.util.Logger;

public class VaultProvider
implements PermissionProvider {
    private final Permission permission;

    public VaultProvider(Permission permission) {
        this.permission = permission;
    }

    public static VaultProvider setupProvider(Junction plugin, String groupName) {
        Logger log = plugin.getPluginLogger();
        if (plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
            log.warn("Vault plugin not found!");
            return null;
        }
        RegisteredServiceProvider provider = plugin.getServer().getServicesManager().getRegistration(Permission.class);
        if (provider == null) {
            log.warn("Vault registration failed!");
            return null;
        }
        Permission vault = (Permission)provider.getProvider();
        if (groupName != null && !groupName.isEmpty()) {
            CharSequence[] groups = vault.getGroups();
            boolean groupExists = false;
            for (String string : groups) {
                if (!string.equalsIgnoreCase(groupName)) continue;
                groupExists = true;
                break;
            }
            if (!groupExists) {
                log.warn("Group '" + groupName + "' not found in " + vault.getName());
                log.warn("Available groups: " + String.join((CharSequence)", ", groups));
            } else {
                log.debug("Found group '" + groupName + "' in " + vault.getName());
            }
        }
        return new VaultProvider(vault);
    }

    @Override
    public boolean addPlayerToGroup(Player player, String group) {
        if (this.isPlayerInGroup(player, group)) {
            return true;
        }
        return this.permission.playerAddGroup(null, (OfflinePlayer)player, group);
    }

    @Override
    public boolean isPlayerInGroup(Player player, String group) {
        return this.permission.playerInGroup(null, (OfflinePlayer)player, group);
    }

    @Override
    public boolean removePlayerFromGroup(Player player, String group) {
        if (!this.isPlayerInGroup(player, group)) {
            return true;
        }
        return this.permission.playerRemoveGroup(null, (OfflinePlayer)player, group);
    }

    @Override
    public String getName() {
        return "Vault";
    }
}

