/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.junction.permission;

import net.luckperms.api.LuckPerms;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.ScopedNode;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.maboroshi.junction.Junction;
import org.maboroshi.junction.permission.PermissionProvider;
import org.maboroshi.junction.util.Logger;

public class LuckPermsProvider
implements PermissionProvider {
    private final LuckPerms luckPerms;

    private LuckPermsProvider(LuckPerms luckPerms) {
        this.luckPerms = luckPerms;
    }

    public static LuckPermsProvider setupProvider(Junction plugin, String groupName) {
        Logger log = plugin.getPluginLogger();
        if (plugin.getServer().getPluginManager().getPlugin("LuckPerms") == null) {
            log.warn("LuckPerms plugin not found!");
            return null;
        }
        RegisteredServiceProvider provider = plugin.getServer().getServicesManager().getRegistration(LuckPerms.class);
        if (provider == null) {
            log.warn("LuckPerms registration failed!");
            return null;
        }
        LuckPerms api = (LuckPerms)provider.getProvider();
        if (groupName != null && !groupName.isEmpty()) {
            if (api.getGroupManager().getGroup(groupName) == null) {
                log.warn("Group '" + groupName + "' not found in LuckPerms.");
            } else {
                log.debug("Found group '" + groupName + "' in LuckPerms.");
            }
        }
        log.info("LuckPerms provider initialized.");
        return new LuckPermsProvider(api);
    }

    @Override
    public boolean addPlayerToGroup(Player player, String group) {
        if (this.isPlayerInGroup(player, group)) {
            return true;
        }
        this.luckPerms.getUserManager().modifyUser(player.getUniqueId(), user -> {
            ScopedNode node = Node.builder((String)("group." + group)).build();
            user.data().add((Node)node);
        });
        return true;
    }

    @Override
    public boolean isPlayerInGroup(Player player, String group) {
        return player.hasPermission("group." + group);
    }

    @Override
    public boolean removePlayerFromGroup(Player player, String group) {
        if (!this.isPlayerInGroup(player, group)) {
            return true;
        }
        this.luckPerms.getUserManager().modifyUser(player.getUniqueId(), user -> {
            ScopedNode node = Node.builder((String)("group." + group)).build();
            user.data().remove((Node)node);
        });
        return true;
    }

    @Override
    public String getName() {
        return "LuckPerms";
    }
}

