/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.junction.config.settings;

import de.exlll.configlib.Comment;
import de.exlll.configlib.ConfigLib;
import de.exlll.configlib.Configuration;
import de.exlll.configlib.YamlConfigurationProperties;
import de.exlll.configlib.YamlConfigurations;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public final class MainConfig {
    public static MainConfiguration load(File dataFolder) {
        YamlConfigurationProperties properties = ConfigLib.BUKKIT_DEFAULT_PROPERTIES.toBuilder().build();
        Path configFile = new File(dataFolder, "config.yml").toPath();
        return (MainConfiguration)YamlConfigurations.update((Path)configFile, MainConfiguration.class, (YamlConfigurationProperties)properties);
    }

    @Configuration
    public static class MainConfiguration {
        @Comment(value={"Should debug mode be enabled for detailed logs?"})
        public boolean debug = false;
        @Comment(value={"This module automatically assigns Bedrock Edition players to a specific group."})
        public PermissionSettings permissions = new PermissionSettings();
        @Comment(value={"This module automatically executes commands based on Minecraft editions.", "Available internal placeholders: {player}, {uuid}", "PlaceholderAPI support is enabled if installed."})
        public CommandSettings commands = new CommandSettings();
    }

    @Configuration
    public static class EventCommands {
        @Comment(value={"List of console commands to execute when a player joins."})
        public List<String> join = new ArrayList<String>();
        @Comment(value={"List of console commands to execute when a player quits."})
        public List<String> quit = new ArrayList<String>();

        public EventCommands() {
        }

        public EventCommands(List<String> join, List<String> quit) {
            this.join = new ArrayList<String>(join);
            this.quit = new ArrayList<String>(quit);
        }
    }

    @Configuration
    public static class CommandSettings {
        @Comment(value={"Should this module be enabled?"})
        public boolean enabled = false;
        @Comment(value={"Commands specific to Java Edition players."})
        public EventCommands java = new EventCommands(List.of("say Java player {player} joined"), List.of("say Java player {player} left"));
        @Comment(value={"Commands specific to Bedrock Edition players."})
        public EventCommands bedrock = new EventCommands(List.of("say Bedrock player {player} joined"), List.of("say Bedrock player {player} left"));
    }

    @Configuration
    public static class PermissionSettings {
        @Comment(value={"Should this module be enabled?"})
        public boolean enabled = false;
        @Comment(value={"Which permission provider should be used?", "Available options: LuckPerms, Vault"})
        public String provider = "LuckPerms";
        @Comment(value={"Which permission group should players be assigned to?"})
        public String group = "geyser";
    }
}

