/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.junction;

import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.maboroshi.junction.command.JunctionCommand;
import org.maboroshi.junction.config.ConfigManager;
import org.maboroshi.junction.libs.bstats.bukkit.Metrics;
import org.maboroshi.junction.listener.PlayerJoinListener;
import org.maboroshi.junction.listener.PlayerQuitListener;
import org.maboroshi.junction.permission.PermissionProvider;
import org.maboroshi.junction.permission.ProviderManager;
import org.maboroshi.junction.util.Logger;
import org.maboroshi.junction.util.MessageUtils;
import org.maboroshi.junction.util.UpdateChecker;

public final class Junction
extends JavaPlugin {
    private static Junction plugin;
    private ConfigManager config;
    private PermissionProvider permissionProvider;
    private Logger log;
    private MessageUtils messageUtils;

    public void onEnable() {
        plugin = this;
        this.log = new Logger(this);
        UpdateChecker updateChecker = new UpdateChecker(this);
        updateChecker.checkForUpdates();
        if (!this.reload()) {
            this.log.error("Disabling plugin due to critical configuration error.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        Metrics metrics = new Metrics((Plugin)this, 28238);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerQuitListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)updateChecker, (Plugin)this);
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> {
            JunctionCommand junctionCommand = new JunctionCommand(this);
            ((Commands)event.registrar()).register(junctionCommand.createCommand("junction"), "Main Junction command");
        });
        this.log.info("Plugin enabled successfully");
    }

    public boolean reload() {
        try {
            this.config = new ConfigManager(this.getDataFolder());
            this.config.load();
            this.messageUtils = new MessageUtils(this.config);
            this.permissionProvider = ProviderManager.initializeProvider(this);
            return true;
        }
        catch (Exception e) {
            this.log.error("Failed to load configuration: " + e.getMessage());
            return false;
        }
    }

    public static Junction getPlugin() {
        return plugin;
    }

    public Logger getPluginLogger() {
        return this.log;
    }

    public ConfigManager getConfiguration() {
        return this.config;
    }

    public MessageUtils getMessageUtils() {
        return this.messageUtils;
    }

    public PermissionProvider getPermissionProvider() {
        return this.permissionProvider;
    }
}

