/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.junction.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import org.maboroshi.junction.Junction;

public class UpdateChecker {
    private final Junction plugin;

    public UpdateChecker(Junction plugin) {
        this.plugin = plugin;
    }

    public void checkForUpdates() {
        CompletableFuture.supplyAsync(() -> {
            try {
                HttpClient client = HttpClient.newHttpClient();
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.github.com/repos/MaboroshiKobo/Junction/releases/latest")).build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() != 200) {
                    throw new RuntimeException("GitHub returned code " + response.statusCode());
                }
                return response.body();
            }
            catch (Exception e) {
                this.plugin.getPluginLogger().warn("Update check failed: " + e.getMessage());
                return null;
            }
        }).thenAccept(jsonResponse -> {
            if (jsonResponse == null) {
                return;
            }
            JsonObject json = JsonParser.parseString((String)jsonResponse).getAsJsonObject();
            if (json.has("tag_name")) {
                String tagName = json.get("tag_name").getAsString().replace("v", "");
                String currentVersion = this.plugin.getPluginMeta().getVersion();
                if (this.isNewer(currentVersion, tagName)) {
                    this.plugin.getPluginLogger().warn("A new version is available! (Current: " + currentVersion + " | Latest: " + tagName + ")");
                    this.plugin.getPluginLogger().warn("Download it at: https://github.com/MaboroshiKobo/Junction/releases/latest");
                }
            }
        });
    }

    private boolean isNewer(String current, String remote) {
        current = current.replace("v", "").split("-")[0];
        remote = remote.replace("v", "").split("-")[0];
        String[] currentParts = current.split("\\.");
        String[] remoteParts = remote.split("\\.");
        int length = Math.max(currentParts.length, remoteParts.length);
        for (int i = 0; i < length; ++i) {
            int v2;
            int v1 = i < currentParts.length ? Integer.parseInt(currentParts[i]) : 0;
            int n = v2 = i < remoteParts.length ? Integer.parseInt(remoteParts[i]) : 0;
            if (v2 > v1) {
                return true;
            }
            if (v2 >= v1) continue;
            return false;
        }
        return false;
    }
}

