/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.junction.permission;

import java.util.UUID;
import net.milkbowl.vault2.helper.subject.Subject;
import net.milkbowl.vault2.permission.PermissionUnlocked;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.maboroshi.junction.Junction;
import org.maboroshi.junction.permission.PermissionProvider;
import org.maboroshi.junction.util.Logger;

public class VaultUnlockedProvider
implements PermissionProvider {
    private final PermissionUnlocked permission;

    public VaultUnlockedProvider(PermissionUnlocked permission) {
        this.permission = permission;
    }

    public static VaultUnlockedProvider setupProvider() {
        Logger log = Junction.getPlugin().getPluginLogger();
        if (Bukkit.getPluginManager().getPlugin("Vault") == null) {
            log.warn("Vault plugin not found!");
            return null;
        }
        RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(PermissionUnlocked.class);
        if (provider == null) {
            log.warn("Vault registration failed!");
            return null;
        }
        return new VaultUnlockedProvider((PermissionUnlocked)provider.getProvider());
    }

    private Subject getSubject(Player player) {
        return Subject.player((UUID)player.getUniqueId(), (String)player.getName());
    }

    @Override
    public boolean addPlayerToGroup(Player player, String group) {
        return this.permission.addGroup(null, this.getSubject(player), group);
    }

    @Override
    public boolean removePlayerFromGroup(Player player, String group) {
        return this.permission.removeGroup(null, this.getSubject(player), group);
    }

    @Override
    public String getName() {
        return "Vault";
    }
}

