/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.junction.permission;

import net.luckperms.api.LuckPerms;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.ScopedNode;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.maboroshi.junction.Junction;
import org.maboroshi.junction.permission.PermissionProvider;
import org.maboroshi.junction.util.Logger;

public class LuckPermsProvider
implements PermissionProvider {
    private final LuckPerms luckPerms;

    private LuckPermsProvider(LuckPerms luckPerms) {
        this.luckPerms = luckPerms;
    }

    public static LuckPermsProvider setupProvider() {
        Logger log = Junction.getPlugin().getPluginLogger();
        if (Bukkit.getPluginManager().getPlugin("LuckPerms") == null) {
            log.warn("LuckPerms plugin not found!");
            return null;
        }
        RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(LuckPerms.class);
        if (provider == null) {
            log.warn("LuckPerms registration failed!");
            return null;
        }
        log.info("LuckPerms provider initialized.");
        return new LuckPermsProvider((LuckPerms)provider.getProvider());
    }

    @Override
    public boolean addPlayerToGroup(Player player, String group) {
        this.luckPerms.getUserManager().modifyUser(player.getUniqueId(), user -> {
            ScopedNode node = Node.builder((String)("group." + group)).build();
            user.data().add((Node)node);
        });
        return true;
    }

    @Override
    public boolean removePlayerFromGroup(Player player, String group) {
        this.luckPerms.getUserManager().modifyUser(player.getUniqueId(), user -> {
            ScopedNode node = Node.builder((String)("group." + group)).build();
            user.data().remove((Node)node);
        });
        return true;
    }

    @Override
    public String getName() {
        return "LuckPerms";
    }
}

