/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.junction.listener;

import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.geysermc.floodgate.api.FloodgateApi;
import org.maboroshi.junction.Junction;
import org.maboroshi.junction.config.ConfigManager;
import org.maboroshi.junction.config.settings.MainConfig;
import org.maboroshi.junction.permission.PermissionProvider;
import org.maboroshi.junction.util.CommandUtils;
import org.maboroshi.junction.util.Logger;
import org.maboroshi.junction.util.MessageUtils;

public class PlayerJoinListener
implements Listener {
    private final Junction plugin;

    public PlayerJoinListener(Junction plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Logger log = this.plugin.getPluginLogger();
        ConfigManager config = this.plugin.getConfiguration();
        MessageUtils messageUtils = this.plugin.getMessageUtils();
        Player player = event.getPlayer();
        PermissionProvider permissionProvider = this.plugin.getPermissionProvider();
        boolean isBedrock = FloodgateApi.getInstance().isFloodgatePlayer(player.getUniqueId());
        log.debug("Player join event triggered: " + player.getName() + " (Bedrock: " + isBedrock + ")");
        if (permissionProvider != null) {
            String groupName = config.getMainConfig().permissions.group;
            if (isBedrock) {
                permissionProvider.addPlayerToGroup(player, groupName);
                log.debug("Ensured Bedrock player " + player.getName() + " is in group: " + groupName);
            } else {
                permissionProvider.removePlayerFromGroup(player, groupName);
                log.debug("Ensured Java player " + player.getName() + " is not in group: " + groupName);
            }
        }
        if (config.getMainConfig().commands.enabled) {
            this.handleCommands(player, isBedrock, config, messageUtils);
        }
    }

    private void handleCommands(Player player, boolean isBedrock, ConfigManager config, MessageUtils messageUtils) {
        List<MainConfig.CommandEntry> commands = isBedrock ? config.getMainConfig().commands.bedrock.join : config.getMainConfig().commands.java.join;
        CommandUtils.dispatch(player, commands, messageUtils);
    }
}

