/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.junction.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.maboroshi.junction.Junction;
import org.maboroshi.junction.config.ConfigManager;
import org.maboroshi.junction.util.MessageUtils;

public class UpdateChecker
implements Listener {
    private final Junction plugin;
    private final ConfigManager config;
    private final MessageUtils messageUtils;
    private boolean updateAvailable = false;
    private String latestVersion = "";

    public UpdateChecker(Junction plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfiguration();
        this.messageUtils = plugin.getMessageUtils();
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.updateAvailable && player.hasPermission("junction.admin")) {
            this.plugin.getPluginLogger().debug("Notifying " + player.getName() + " about available update.");
            this.messageUtils.send((Audience)player, this.config.getMessageConfig().messages.updateAvailable, this.messageUtils.tag("current_version", this.plugin.getPluginMeta().getVersion()), this.messageUtils.tag("latest_version", this.latestVersion));
        }
    }

    public void checkForUpdates() {
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                HttpClient client = HttpClient.newHttpClient();
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.github.com/repos/MaboroshiKobo/Junction/releases/latest")).build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() != 200) {
                    throw new RuntimeException("GitHub returned code " + response.statusCode());
                }
                return response.body();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).thenAccept(jsonResponse -> {
            JsonObject json = JsonParser.parseString((String)jsonResponse).getAsJsonObject();
            if (json.has("tag_name")) {
                String tagName = json.get("tag_name").getAsString().replace("v", "");
                if (this.isNewer(this.plugin.getPluginMeta().getVersion(), tagName)) {
                    this.updateAvailable = true;
                    this.latestVersion = tagName;
                }
            }
        })).exceptionally(exception -> {
            this.plugin.getPluginLogger().warn("Update check failed: " + exception.getMessage());
            return null;
        });
    }

    private boolean isNewer(String current, String remote) {
        current = current.replace("v", "").split("-")[0];
        remote = remote.replace("v", "").split("-")[0];
        String[] currentParts = current.split("\\.");
        String[] remoteParts = remote.split("\\.");
        int length = Math.max(currentParts.length, remoteParts.length);
        for (int i = 0; i < length; ++i) {
            int v2;
            int v1 = i < currentParts.length ? Integer.parseInt(currentParts[i]) : 0;
            int n = v2 = i < remoteParts.length ? Integer.parseInt(remoteParts[i]) : 0;
            if (v2 > v1) {
                return true;
            }
            if (v2 >= v1) continue;
            return false;
        }
        return false;
    }
}

