/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.junction.util;

import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.maboroshi.junction.Junction;
import org.maboroshi.junction.config.settings.MainConfig;
import org.maboroshi.junction.util.MessageUtils;

public class CommandUtils {
    public static void dispatch(Player player, List<MainConfig.CommandEntry> commands, MessageUtils messageUtils) {
        if (commands == null || commands.isEmpty()) {
            return;
        }
        long totalDelay = 0L;
        for (MainConfig.CommandEntry entry : commands) {
            Component parsedComponent = messageUtils.parse((Audience)player, entry.command, messageUtils.tag("uuid", player.getUniqueId()));
            String finalCommand = LegacyComponentSerializer.legacySection().serialize(parsedComponent);
            if (finalCommand.startsWith("/")) {
                finalCommand = finalCommand.substring(1);
            }
            String commandToRun = finalCommand;
            long delayTicks = totalDelay + (long)entry.delay;
            if (Junction.isFolia()) {
                Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)Junction.getPlugin(), task -> {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)commandToRun);
                    CommandUtils.debug(commandToRun, delayTicks);
                }, delayTicks);
            } else {
                Bukkit.getScheduler().runTaskLater((Plugin)Junction.getPlugin(), () -> {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)commandToRun);
                    CommandUtils.debug(commandToRun, delayTicks);
                }, delayTicks);
            }
            totalDelay += (long)entry.delay;
        }
    }

    private static void debug(String cmd, long delay) {
        Junction.getPlugin().getPluginLogger().debug("Executed command: " + cmd + " (Total delay: " + delay + ")");
    }
}

