/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.junction.config.settings;

import de.exlll.configlib.Comment;
import de.exlll.configlib.ConfigLib;
import de.exlll.configlib.Configuration;
import de.exlll.configlib.NameFormatter;
import de.exlll.configlib.NameFormatters;
import de.exlll.configlib.YamlConfigurationProperties;
import de.exlll.configlib.YamlConfigurations;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public final class MainConfig {
    public static MainConfiguration load(File dataFolder) {
        YamlConfigurationProperties properties = ((YamlConfigurationProperties.Builder)ConfigLib.BUKKIT_DEFAULT_PROPERTIES.toBuilder().setNameFormatter((NameFormatter)NameFormatters.LOWER_KEBAB_CASE)).build();
        Path configFile = new File(dataFolder, "config.yml").toPath();
        return (MainConfiguration)YamlConfigurations.update((Path)configFile, MainConfiguration.class, (YamlConfigurationProperties)properties);
    }

    @Configuration
    public static class MainConfiguration {
        @Comment(value={"Should debug mode be enabled for detailed logs?"})
        public boolean debug = false;
        @Comment(value={"This module automatically assigns Bedrock Edition players to a specific group."})
        public PermissionSettings permissions = new PermissionSettings();
        @Comment(value={"This module automatically executes commands based on Minecraft editions.", "Available internal placeholders: <player>, <uuid>", "PlaceholderAPI support is enabled if installed."})
        public CommandSettings commands = new CommandSettings();
    }

    @Configuration
    public static class CommandSettings {
        @Comment(value={"Should this module be enabled?"})
        public boolean enabled = false;
        @Comment(value={"Commands specific to Java Edition players."})
        public EventCommands java = new EventCommands(new ArrayList<CommandEntry>(List.of(new CommandEntry("say Welcome <player> to the Java Edition server!", 20))), new ArrayList<CommandEntry>(List.of(new CommandEntry("say Goodbye <player> from the Java Edition server!", 20))));
        @Comment(value={"Commands specific to Bedrock Edition players."})
        public EventCommands bedrock = new EventCommands(new ArrayList<CommandEntry>(List.of(new CommandEntry("say Welcome <player> to the Bedrock Edition server!", 20))), new ArrayList<CommandEntry>(List.of(new CommandEntry("say Goodbye <player> from the Bedrock Edition server!", 20))));
    }

    @Configuration
    public static class EventCommands {
        @Comment(value={"List of console commands to execute when a player joins."})
        public List<CommandEntry> join = new ArrayList<CommandEntry>();
        @Comment(value={"List of console commands to execute when a player quits."})
        public List<CommandEntry> quit = new ArrayList<CommandEntry>();

        public EventCommands() {
        }

        public EventCommands(List<CommandEntry> joinCommands, List<CommandEntry> quitCommands) {
            this.join = joinCommands;
            this.quit = quitCommands;
        }
    }

    @Configuration
    public static class CommandEntry {
        @Comment(value={"Console command to execute."})
        public String command;
        @Comment(value={"Delay in ticks before executing the command (Default: 20 = 1 second)."})
        public int delay = 20;

        public CommandEntry() {
        }

        public CommandEntry(String command, int delay) {
            this.command = command;
            this.delay = delay;
        }
    }

    @Configuration
    public static class PermissionSettings {
        @Comment(value={"Should this module be enabled?"})
        public boolean enabled = false;
        @Comment(value={"Which permission provider should be used?", "Available options: LuckPerms, Vault"})
        public String provider = "LuckPerms";
        @Comment(value={"Which permission group should players be assigned to?"})
        public String group = "geyser";
    }
}

