/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.junction.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.maboroshi.junction.Junction;
import org.maboroshi.junction.config.ConfigManager;
import org.maboroshi.junction.util.Logger;
import org.maboroshi.junction.util.MessageUtils;

public class JunctionCommand {
    private final Junction plugin;
    private final Logger log;
    private final MessageUtils messageUtils;

    public JunctionCommand(Junction plugin) {
        this.plugin = plugin;
        this.log = plugin.getPluginLogger();
        this.messageUtils = plugin.getMessageUtils();
    }

    public LiteralCommandNode<CommandSourceStack> createCommand(String commandName) {
        ConfigManager config = this.plugin.getConfiguration();
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandName).executes(ctx -> {
            CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
            this.messageUtils.send((Audience)sender, "<prefix>Plugin version: <green><version></green>", this.messageUtils.tag("version", this.plugin.getPluginMeta().getVersion()));
            this.messageUtils.send((Audience)sender, "<green>\ud83d\udec8</green> <gray>Type <white>/junction reload</white> to reload the configuration.</gray>", new TagResolver[0]);
            return 1;
        })).then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(sender -> sender.getSender().hasPermission("junction.reload"))).executes(ctx -> {
            CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
            if (this.plugin.reload()) {
                this.log.info("Configuration reloaded by " + sender.getName());
                this.messageUtils.send((Audience)sender, "<prefix>" + config.getMessageConfig().messages.reloadSuccess, new TagResolver[0]);
            } else {
                this.log.warn("Failed to reload configuration by " + sender.getName());
                this.messageUtils.send((Audience)sender, "<prefix>" + config.getMessageConfig().messages.reloadFail, new TagResolver[0]);
            }
            return 1;
        }))).build();
    }
}

