/*
 * Decompiled with CFR 0.152.
 */
package com.mrsuffix.singleplayersleep.utils;

import org.bukkit.World;

public class TimeUtil {
    public static final long DAY_START = 0L;
    public static final long NOON = 6000L;
    public static final long SUNSET_START = 12000L;
    public static final long NIGHT_START = 13000L;
    public static final long MIDNIGHT = 18000L;
    public static final long SUNRISE_START = 23000L;
    public static final long DAY_END = 24000L;
    public static final long MORNING_TIME = 1000L;

    public static boolean isNight(World world) {
        long time = world.getTime();
        return time >= 13000L && time < 23000L;
    }

    public static boolean isDay(World world) {
        return !TimeUtil.isNight(world);
    }

    public static String getTimeDescription(World world) {
        long time = world.getTime();
        if (time >= 0L && time < 6000L) {
            return "Morning";
        }
        if (time >= 6000L && time < 12000L) {
            return "Afternoon";
        }
        if (time >= 12000L && time < 13000L) {
            return "Evening";
        }
        if (time >= 13000L && time < 18000L) {
            return "Night";
        }
        if (time >= 18000L && time < 23000L) {
            return "Late Night";
        }
        return "Dawn";
    }

    public static double getNightProgress(World world) {
        if (!TimeUtil.isNight(world)) {
            return -1.0;
        }
        long time = world.getTime();
        long nightDuration = 10000L;
        long nightElapsed = time - 13000L;
        return (double)nightElapsed / (double)nightDuration;
    }

    public static long getTicksUntilSunrise(World world) {
        if (!TimeUtil.isNight(world)) {
            return 0L;
        }
        long time = world.getTime();
        return 23000L - time;
    }

    public static String formatTime(long ticks) {
        long seconds = ticks / 20L;
        long minutes = seconds / 60L;
        seconds %= 60L;
        if (minutes > 0L) {
            return String.format("%dm %ds", minutes, seconds);
        }
        return String.format("%ds", seconds);
    }
}

