/*
 * Decompiled with CFR 0.152.
 */
package com.mrsuffix.singleplayersleep.utils;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MessageUtil {
    public static void sendMessage(CommandSender sender, String message) {
        sender.sendMessage(MessageUtil.colorize(message));
    }

    public static void sendMessage(Player player, String message) {
        player.sendMessage(MessageUtil.colorize(message));
    }

    public static void broadcastMessage(String message) {
        Bukkit.broadcastMessage((String)MessageUtil.colorize(message));
    }

    public static void broadcastToWorld(String worldName, String message) {
        World world = Bukkit.getWorld((String)worldName);
        if (world != null) {
            world.getPlayers().forEach(player -> MessageUtil.sendMessage(player, message));
        }
    }

    public static String colorize(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static String stripColors(String message) {
        return ChatColor.stripColor((String)MessageUtil.colorize(message));
    }
}

