/*
 * Decompiled with CFR 0.152.
 */
package com.mrsuffix.singleplayersleep.utils;

import com.mrsuffix.singleplayersleep.SinglePlayerSleep;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class EffectUtil {
    public static void playSleepEffects(Player player) {
        SinglePlayerSleep plugin = SinglePlayerSleep.getInstance();
        if (!plugin.getConfigManager().areParticlesEnabled() && !plugin.getConfigManager().areSoundsEnabled()) {
            return;
        }
        final Location location = player.getLocation();
        final World world = player.getWorld();
        final int particleCount = EffectUtil.calculateParticleCount(world);
        if (plugin.getConfigManager().areSoundsEnabled()) {
            world.playSound(location, Sound.BLOCK_NOTE_BLOCK_CHIME, 1.0f, 1.0f);
            plugin.debugLog("Played sleep sound for " + player.getName());
        }
        if (plugin.getConfigManager().areParticlesEnabled()) {
            new BukkitRunnable(){
                int count = 0;

                public void run() {
                    if (this.count >= 20) {
                        this.cancel();
                        return;
                    }
                    Location particleLocation = location.clone().add((Math.random() - 0.5) * 3.0, Math.random() * 2.0 + 1.0, (Math.random() - 0.5) * 3.0);
                    world.spawnParticle(Particle.CLOUD, particleLocation, Math.max(1, particleCount / 2), 0.1, 0.1, 0.1, 0.01);
                    world.spawnParticle(Particle.ENCHANTMENT_TABLE, particleLocation, particleCount, 0.2, 0.2, 0.2, 0.1);
                    ++this.count;
                }
            }.runTaskTimer((Plugin)plugin, 0L, 1L);
            plugin.debugLog("Started sleep particle effects for " + player.getName());
        }
    }

    public static void playMorningEffects(Player player) {
        SinglePlayerSleep plugin = SinglePlayerSleep.getInstance();
        if (!plugin.getConfigManager().areParticlesEnabled() && !plugin.getConfigManager().areSoundsEnabled()) {
            return;
        }
        final Location location = player.getLocation();
        final World world = player.getWorld();
        final int particleCount = EffectUtil.calculateParticleCount(world);
        if (plugin.getConfigManager().areSoundsEnabled()) {
            world.playSound(location, Sound.ENTITY_CHICKEN_AMBIENT, 1.0f, 0.8f);
            new BukkitRunnable(){

                public void run() {
                    world.playSound(location, Sound.BLOCK_NOTE_BLOCK_BELL, 0.7f, 1.2f);
                }
            }.runTaskLater((Plugin)plugin, 10L);
            plugin.debugLog("Played morning sounds for " + player.getName());
        }
        if (plugin.getConfigManager().areParticlesEnabled()) {
            new BukkitRunnable(){
                int count = 0;

                public void run() {
                    if (this.count >= 30) {
                        this.cancel();
                        return;
                    }
                    Location particleLocation = location.clone().add((Math.random() - 0.5) * 4.0, Math.random() * 3.0 + 1.0, (Math.random() - 0.5) * 4.0);
                    world.spawnParticle(Particle.FLAME, particleLocation, Math.max(1, particleCount / 2), 0.1, 0.1, 0.1, 0.01);
                    world.spawnParticle(Particle.VILLAGER_HAPPY, particleLocation, particleCount, 0.3, 0.3, 0.3, 0.1);
                    if (this.count % 10 == 0) {
                        world.spawnParticle(Particle.FIREWORKS_SPARK, location.clone().add(0.0, 3.0, 0.0), 5, 1.0, 1.0, 1.0, 0.1);
                    }
                    ++this.count;
                }
            }.runTaskTimer((Plugin)plugin, 0L, 1L);
            plugin.debugLog("Started morning particle effects for " + player.getName());
        }
    }

    public static void showCountdown(final Player player, final int seconds) {
        final SinglePlayerSleep plugin = SinglePlayerSleep.getInstance();
        new BukkitRunnable(){
            int remaining;
            {
                this.remaining = seconds;
            }

            public void run() {
                if (this.remaining <= 0) {
                    this.cancel();
                    return;
                }
                player.sendActionBar(String.valueOf(ChatColor.YELLOW) + "Night skip in: " + String.valueOf(ChatColor.GOLD) + this.remaining + "s");
                if (plugin.getConfigManager().areSoundsEnabled()) {
                    player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 0.5f, 1.0f + (float)this.remaining * 0.1f);
                }
                --this.remaining;
            }
        }.runTaskTimer((Plugin)plugin, 0L, 20L);
    }

    private static int calculateParticleCount(World world) {
        SinglePlayerSleep plugin = SinglePlayerSleep.getInstance();
        if (!plugin.getConfigManager().isParticleOptimizeEnabled()) {
            return 2;
        }
        int playerCount = world.getPlayers().size();
        int maxPerPlayer = plugin.getConfigManager().getMaxParticlesPerPlayer();
        if (playerCount <= 1) {
            return maxPerPlayer;
        }
        if (playerCount <= 5) {
            return Math.max(2, maxPerPlayer / 2);
        }
        if (playerCount <= 10) {
            return Math.max(1, maxPerPlayer / 3);
        }
        return 1;
    }
}

