/*
 * Decompiled with CFR 0.152.
 */
package com.mrsuffix.singleplayersleep.managers;

import com.mrsuffix.singleplayersleep.SinglePlayerSleep;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class UpdateChecker {
    private final SinglePlayerSleep plugin;
    private String latestVersion;
    private boolean updateAvailable = false;

    public UpdateChecker(SinglePlayerSleep plugin) {
        this.plugin = plugin;
    }

    public void checkForUpdates() {
        if (!this.plugin.getConfigManager().isUpdateCheckerEnabled()) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                String repo = this.plugin.getConfigManager().getGitHubRepo();
                String apiUrl = "https://api.github.com/repos/" + repo + "/releases/latest";
                this.plugin.debugLog("Checking for updates from: " + apiUrl);
                URL url = new URL(apiUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                connection.setRequestProperty("Accept", "application/vnd.github.v3+json");
                connection.setRequestProperty("User-Agent", "SinglePlayerSleep-UpdateChecker");
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    StringBuilder response = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                    reader.close();
                    String json = response.toString();
                    this.latestVersion = this.extractVersion(json);
                    if (this.latestVersion != null) {
                        String currentVersion = this.plugin.getDescription().getVersion();
                        this.updateAvailable = this.isNewerVersion(currentVersion, this.latestVersion);
                        if (this.updateAvailable) {
                            this.plugin.getLogger().warning("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
                            this.plugin.getLogger().warning("\u2551   UPDATE AVAILABLE!                    \u2551");
                            this.plugin.getLogger().warning("\u2551   Current: " + currentVersion + "                       \u2551");
                            this.plugin.getLogger().warning("\u2551   Latest:  " + this.latestVersion + "                       \u2551");
                            this.plugin.getLogger().warning("\u2551   Download: github.com/" + repo + " \u2551");
                            this.plugin.getLogger().warning("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
                        } else {
                            this.plugin.getLogger().info("Plugin is up to date! (v" + currentVersion + ")");
                        }
                    }
                } else {
                    this.plugin.debugLog("Failed to check for updates. Response code: " + responseCode);
                }
                connection.disconnect();
            }
            catch (Exception e) {
                this.plugin.debugLog("Error checking for updates: " + e.getMessage());
                this.plugin.getLogger().log(Level.WARNING, "Could not check for updates. This is not critical.", e);
            }
        });
    }

    private String extractVersion(String json) {
        try {
            int tagIndex = json.indexOf("\"tag_name\"");
            if (tagIndex == -1) {
                return null;
            }
            int startQuote = json.indexOf("\"", tagIndex + 11);
            int endQuote = json.indexOf("\"", startQuote + 1);
            if (startQuote != -1 && endQuote != -1) {
                String version = json.substring(startQuote + 1, endQuote);
                return version.startsWith("v") ? version.substring(1) : version;
            }
        }
        catch (Exception e) {
            this.plugin.debugLog("Error parsing version from JSON: " + e.getMessage());
        }
        return null;
    }

    private boolean isNewerVersion(String current, String latest) {
        try {
            String[] currentParts = current.split("\\.");
            String[] latestParts = latest.split("\\.");
            int length = Math.max(currentParts.length, latestParts.length);
            for (int i = 0; i < length; ++i) {
                int latestPart;
                int currentPart = i < currentParts.length ? Integer.parseInt(currentParts[i]) : 0;
                int n = latestPart = i < latestParts.length ? Integer.parseInt(latestParts[i]) : 0;
                if (latestPart > currentPart) {
                    return true;
                }
                if (latestPart >= currentPart) continue;
                return false;
            }
        }
        catch (Exception e) {
            this.plugin.debugLog("Error comparing versions: " + e.getMessage());
        }
        return false;
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }
}

