/*
 * Decompiled with CFR 0.152.
 */
package com.mrsuffix.singleplayersleep.managers;

import com.mrsuffix.singleplayersleep.SinglePlayerSleep;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class StatisticsManager {
    private final SinglePlayerSleep plugin;
    private File statisticsFile;
    private FileConfiguration statisticsConfig;
    private long totalSleepCount = 0L;
    private long manualSkips = 0L;
    private final Map<String, Integer> playerSleepCounts = new HashMap<String, Integer>();

    public StatisticsManager(SinglePlayerSleep plugin) {
        this.plugin = plugin;
        this.statisticsFile = new File(plugin.getDataFolder(), "statistics.yml");
    }

    public void loadStatistics() {
        ConfigurationSection section;
        if (!this.statisticsFile.exists()) {
            this.plugin.saveResource("statistics.yml", false);
        }
        this.statisticsConfig = YamlConfiguration.loadConfiguration((File)this.statisticsFile);
        this.totalSleepCount = this.statisticsConfig.getLong("total-sleep-count", 0L);
        this.manualSkips = this.statisticsConfig.getLong("manual-skips", 0L);
        if (this.statisticsConfig.contains("player-sleep-counts") && (section = this.statisticsConfig.getConfigurationSection("player-sleep-counts")) != null) {
            for (String player : section.getKeys(false)) {
                this.playerSleepCounts.put(player, this.statisticsConfig.getInt("player-sleep-counts." + player));
            }
        }
        this.plugin.debugLog("Statistics loaded - Total sleeps: " + this.totalSleepCount + ", Manual skips: " + this.manualSkips);
    }

    public void saveStatistics() {
        this.statisticsConfig.set("total-sleep-count", (Object)this.totalSleepCount);
        this.statisticsConfig.set("manual-skips", (Object)this.manualSkips);
        this.statisticsConfig.set("last-updated", (Object)System.currentTimeMillis());
        this.statisticsConfig.set("player-sleep-counts", null);
        for (Map.Entry<String, Integer> entry : this.playerSleepCounts.entrySet()) {
            this.statisticsConfig.set("player-sleep-counts." + entry.getKey(), (Object)entry.getValue());
        }
        try {
            this.statisticsConfig.save(this.statisticsFile);
            this.plugin.debugLog("Statistics saved");
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save statistics file: " + e.getMessage());
        }
    }

    public void incrementSleepCount() {
        ++this.totalSleepCount;
        this.plugin.debugLog("Sleep count incremented to: " + this.totalSleepCount);
    }

    public void incrementManualSkips() {
        ++this.manualSkips;
        this.plugin.debugLog("Manual skip count incremented to: " + this.manualSkips);
    }

    public void addPlayerSleep(String playerName) {
        this.playerSleepCounts.merge(playerName, 1, Integer::sum);
        this.plugin.debugLog("Player " + playerName + " sleep count: " + String.valueOf(this.playerSleepCounts.get(playerName)));
    }

    public long getTotalSleepCount() {
        return this.totalSleepCount;
    }

    public long getManualSkips() {
        return this.manualSkips;
    }

    public int getPlayerSleepCount(String playerName) {
        return this.playerSleepCounts.getOrDefault(playerName, 0);
    }

    public LinkedHashMap<String, Integer> getTopSleepers(int limit) {
        return this.playerSleepCounts.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(limit).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }
}

