/*
 * Decompiled with CFR 0.152.
 */
package com.mrsuffix.singleplayersleep.managers;

import com.mrsuffix.singleplayersleep.SinglePlayerSleep;
import java.util.HashMap;
import java.util.Map;

public class CooldownManager {
    private final SinglePlayerSleep plugin;
    private final Map<String, Long> worldCooldowns = new HashMap<String, Long>();

    public CooldownManager(SinglePlayerSleep plugin) {
        this.plugin = plugin;
    }

    public void setCooldown(String worldName) {
        long cooldownDuration = this.plugin.getConfigManager().getCooldownDuration() * 1000L;
        long cooldownEnd = System.currentTimeMillis() + cooldownDuration;
        this.worldCooldowns.put(worldName, cooldownEnd);
        this.plugin.debugLog("Cooldown set for world " + worldName + " until " + cooldownEnd);
    }

    public boolean isOnCooldown(String worldName) {
        Long cooldownEnd = this.worldCooldowns.get(worldName);
        if (cooldownEnd == null) {
            return false;
        }
        if (System.currentTimeMillis() >= cooldownEnd) {
            this.worldCooldowns.remove(worldName);
            this.plugin.debugLog("Cooldown expired for world " + worldName);
            return false;
        }
        return true;
    }

    public long getRemainingCooldown(String worldName) {
        Long cooldownEnd = this.worldCooldowns.get(worldName);
        if (cooldownEnd == null) {
            return 0L;
        }
        long remaining = cooldownEnd - System.currentTimeMillis();
        return Math.max(0L, remaining);
    }

    public void clearCooldown(String worldName) {
        this.worldCooldowns.remove(worldName);
        this.plugin.debugLog("Cooldown cleared for world " + worldName);
    }

    public void clearAllCooldowns() {
        this.worldCooldowns.clear();
        this.plugin.debugLog("All cooldowns cleared");
    }

    public Map<String, Long> getAllCooldowns() {
        this.worldCooldowns.entrySet().removeIf(entry -> System.currentTimeMillis() >= (Long)entry.getValue());
        return new HashMap<String, Long>(this.worldCooldowns);
    }
}

