/*
 * Decompiled with CFR 0.152.
 */
package com.mrsuffix.singleplayersleep.managers;

import com.mrsuffix.singleplayersleep.SinglePlayerSleep;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final SinglePlayerSleep plugin;
    private FileConfiguration config;
    private long sleepDelay;
    private long autoSaveDelay;
    private boolean autoSaveEnabled;
    private long cooldownDuration;
    private boolean clearWeather;
    private boolean debugMode;
    private boolean particlesEnabled;
    private boolean soundsEnabled;
    private boolean percentageMode;
    private int sleepPercentage;
    private boolean afkDetectionEnabled;
    private long afkTimeout;
    private boolean ignoreAFKPlayers;
    private boolean particleOptimize;
    private int maxParticlesPerPlayer;
    private boolean updateCheckerEnabled;
    private String githubRepo;

    public ConfigManager(SinglePlayerSleep plugin) {
        this.plugin = plugin;
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.cacheConfigValues();
        this.plugin.debugLog("Configuration loaded and cached");
    }

    private void cacheConfigValues() {
        this.sleepDelay = this.config.getLong("sleep-delay-ticks", 65L);
        this.autoSaveDelay = this.config.getLong("auto-save.delay-ticks", 10L);
        this.autoSaveEnabled = this.config.getBoolean("auto-save.enabled", true);
        this.cooldownDuration = this.config.getLong("cooldown-seconds", 30L);
        this.clearWeather = this.config.getBoolean("clear-weather", true);
        this.debugMode = this.config.getBoolean("debug-mode", false);
        this.particlesEnabled = this.config.getBoolean("effects.particles.enabled", true);
        this.soundsEnabled = this.config.getBoolean("effects.sounds.enabled", true);
        this.percentageMode = this.config.getBoolean("percentage-mode", false);
        this.sleepPercentage = this.config.getInt("sleep-percentage", 50);
        this.afkDetectionEnabled = this.config.getBoolean("afk-detection.enabled", true);
        this.afkTimeout = this.config.getLong("afk-detection.timeout-seconds", 300L);
        this.ignoreAFKPlayers = this.config.getBoolean("afk-detection.ignore-afk-players", true);
        this.particleOptimize = this.config.getBoolean("effects.particles.optimize", true);
        this.maxParticlesPerPlayer = this.config.getInt("effects.particles.max-per-player", 10);
        this.updateCheckerEnabled = this.config.getBoolean("update-checker.enabled", true);
        this.githubRepo = this.config.getString("update-checker.github-repo", "MRsuffixx/SinglePlayerSleep");
    }

    public long getSleepDelay() {
        return this.sleepDelay;
    }

    public long getAutoSaveDelay() {
        return this.autoSaveDelay;
    }

    public boolean isAutoSaveEnabled() {
        return this.autoSaveEnabled;
    }

    public long getCooldownDuration() {
        return this.cooldownDuration;
    }

    public boolean shouldClearWeather() {
        return this.clearWeather;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean enabled) {
        this.debugMode = enabled;
        this.config.set("debug-mode", (Object)enabled);
        this.plugin.saveConfig();
    }

    public boolean isWorldEnabled(String worldName) {
        List enabledWorlds = this.config.getStringList("enabled-worlds");
        return enabledWorlds.isEmpty() || enabledWorlds.contains(worldName);
    }

    public String getMessage(String key) {
        return this.config.getString("messages." + key, "&cMessage not found: " + key);
    }

    public boolean areParticlesEnabled() {
        return this.particlesEnabled;
    }

    public boolean areSoundsEnabled() {
        return this.soundsEnabled;
    }

    public boolean isPercentageMode() {
        return this.percentageMode;
    }

    public int getSleepPercentage() {
        return this.sleepPercentage;
    }

    public boolean isAFKDetectionEnabled() {
        return this.afkDetectionEnabled;
    }

    public long getAFKTimeout() {
        return this.afkTimeout;
    }

    public boolean shouldIgnoreAFKPlayers() {
        return this.ignoreAFKPlayers;
    }

    public boolean isParticleOptimizeEnabled() {
        return this.particleOptimize;
    }

    public int getMaxParticlesPerPlayer() {
        return this.maxParticlesPerPlayer;
    }

    public boolean isUpdateCheckerEnabled() {
        return this.updateCheckerEnabled;
    }

    public String getGitHubRepo() {
        return this.githubRepo;
    }
}

